/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.IArtist;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.layer.ForestEdgeLayer;
import net.dries007.tfc.world.layer.ForestInitLayer;
import net.dries007.tfc.world.layer.ForestRandomizeLayer;
import net.dries007.tfc.world.layer.ForestRandomizeSmallLayer;
import net.dries007.tfc.world.layer.MoreShoresLayer;
import net.dries007.tfc.world.layer.RegionBiomeLayer;
import net.dries007.tfc.world.layer.RegionEdgeBiomeLayer;
import net.dries007.tfc.world.layer.RegionLayer;
import net.dries007.tfc.world.layer.RegionRockLayer;
import net.dries007.tfc.world.layer.ShoreLayer;
import net.dries007.tfc.world.layer.SmoothLayer;
import net.dries007.tfc.world.layer.UniformLayer;
import net.dries007.tfc.world.layer.ZoomLayer;
import net.dries007.tfc.world.layer.framework.AreaFactory;
import net.dries007.tfc.world.layer.framework.TypedAreaFactory;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.mutable.MutableInt;

public class TFCLayers {
    public static final int FOREST_NONE = ForestType.NONE.ordinal();
    public static final int FOREST_NORMAL = ForestType.NORMAL.ordinal();
    public static final int FOREST_SPARSE = ForestType.SPARSE.ordinal();
    public static final int FOREST_EDGE = ForestType.EDGE.ordinal();
    public static final int FOREST_OLD = ForestType.OLD_GROWTH.ordinal();
    public static final int OCEAN;
    public static final int OCEAN_REEF;
    public static final int DEEP_OCEAN;
    public static final int DEEP_OCEAN_TRENCH;
    public static final int PLAINS;
    public static final int HILLS;
    public static final int LOWLANDS;
    public static final int SALT_MARSH;
    public static final int LOW_CANYONS;
    public static final int ROLLING_HILLS;
    public static final int HIGHLANDS;
    public static final int BADLANDS;
    public static final int INVERTED_BADLANDS;
    public static final int PLATEAU;
    public static final int OLD_MOUNTAINS;
    public static final int MOUNTAINS;
    public static final int VOLCANIC_MOUNTAINS;
    public static final int OCEANIC_MOUNTAINS;
    public static final int VOLCANIC_OCEANIC_MOUNTAINS;
    public static final int CANYONS;
    public static final int SHORE;
    public static final int TIDAL_FLATS;
    public static final int LAKE;
    public static final int RIVER;
    public static final int MOUNTAIN_LAKE;
    public static final int VOLCANIC_MOUNTAIN_LAKE;
    public static final int OLD_MOUNTAIN_LAKE;
    public static final int OCEANIC_MOUNTAIN_LAKE;
    public static final int VOLCANIC_OCEANIC_MOUNTAIN_LAKE;
    public static final int PLATEAU_LAKE;
    private static final BiomeExtension[] BIOME_LAYERS;
    private static final MutableInt BIOME_LAYER_INDEX;

    public static BiomeExtension getFromLayerId(int id) {
        BiomeExtension v = BIOME_LAYERS[id];
        if (v == null) {
            throw new NullPointerException("Layer id = " + id + " returned null!");
        }
        return v;
    }

    public static AreaFactory createOverworldForestLayer(long seed, IArtist<AreaFactory> artist) {
        Random random = new Random(seed);
        AreaFactory layer = new ForestInitLayer(new OpenSimplex2D(random.nextInt()).spread(0.3f)).apply(random.nextLong());
        artist.draw("forest", 1, layer);
        layer = ForestRandomizeLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 2, layer);
        layer = ZoomLayer.FUZZY.apply(random.nextLong(), layer);
        artist.draw("forest", 3, layer);
        layer = ForestRandomizeLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 4, layer);
        layer = ZoomLayer.FUZZY.apply(random.nextLong(), layer);
        artist.draw("forest", 5, layer);
        layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
        artist.draw("forest", 6, layer);
        layer = ForestEdgeLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 7, layer);
        layer = ForestRandomizeSmallLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 8, layer);
        for (int i = 0; i < 2; ++i) {
            layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
            artist.draw("forest", 9 + i, layer);
        }
        return layer;
    }

    public static AreaFactory createOverworldRockLayer(RegionGenerator generator, long seed) {
        Random random = new Random(seed);
        TypedAreaFactory<Region.Point> regionLayer = new RegionLayer(generator).apply(random.nextLong());
        AreaFactory layer = RegionRockLayer.INSTANCE.apply(regionLayer);
        for (int i = 0; i < 6; ++i) {
            layer = ZoomLayer.NORMAL.apply(seed, layer);
        }
        layer = SmoothLayer.INSTANCE.apply(seed, layer);
        layer = ZoomLayer.NORMAL.apply(seed, layer);
        layer = SmoothLayer.INSTANCE.apply(seed, layer);
        return layer;
    }

    public static AreaFactory createRegionBiomeLayer(RegionGenerator generator, long seed) {
        Random random = new Random(seed);
        TypedAreaFactory<Region.Point> regionLayer = new RegionLayer(generator).apply(random.nextLong());
        AreaFactory mainLayer = RegionBiomeLayer.INSTANCE.apply(regionLayer);
        mainLayer = RegionEdgeBiomeLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ShoreLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        mainLayer = MoreShoresLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = SmoothLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        return mainLayer;
    }

    public static AreaFactory createUniformLayer(RandomSource random, int zoomLevels) {
        AreaFactory layer = UniformLayer.INSTANCE.apply(random.m_188505_());
        for (int i = 0; i < zoomLevels; ++i) {
            layer = ZoomLayer.NORMAL.apply(random.m_188505_(), layer);
            layer = SmoothLayer.INSTANCE.apply(random.m_188505_(), layer);
        }
        return layer;
    }

    public static boolean hasShore(int value) {
        return value != LOWLANDS && value != SALT_MARSH && value != LOW_CANYONS && value != CANYONS && value != OCEANIC_MOUNTAINS && value != VOLCANIC_OCEANIC_MOUNTAINS;
    }

    public static int shoreFor(int value) {
        if (value == MOUNTAINS) {
            return OCEANIC_MOUNTAINS;
        }
        if (value == VOLCANIC_MOUNTAINS) {
            return VOLCANIC_OCEANIC_MOUNTAINS;
        }
        return SHORE;
    }

    public static boolean hasLake(int value) {
        return !TFCLayers.isOcean(value) && value != BADLANDS;
    }

    public static int lakeFor(int value) {
        if (value == MOUNTAINS) {
            return MOUNTAIN_LAKE;
        }
        if (value == VOLCANIC_MOUNTAINS) {
            return VOLCANIC_MOUNTAIN_LAKE;
        }
        if (value == OLD_MOUNTAINS) {
            return OLD_MOUNTAIN_LAKE;
        }
        if (value == OCEANIC_MOUNTAINS) {
            return OCEANIC_MOUNTAIN_LAKE;
        }
        if (value == VOLCANIC_OCEANIC_MOUNTAINS) {
            return VOLCANIC_OCEANIC_MOUNTAIN_LAKE;
        }
        if (value == PLATEAU) {
            return PLATEAU_LAKE;
        }
        return LAKE;
    }

    public static boolean isOcean(int value) {
        return value == OCEAN || value == DEEP_OCEAN || value == DEEP_OCEAN_TRENCH || value == OCEAN_REEF;
    }

    public static boolean isMountains(int value) {
        return value == MOUNTAINS || value == OCEANIC_MOUNTAINS || value == OLD_MOUNTAINS || value == VOLCANIC_MOUNTAINS || value == VOLCANIC_OCEANIC_MOUNTAINS;
    }

    public static boolean isLow(int value) {
        return value == PLAINS || value == HILLS || value == LOW_CANYONS || value == LOWLANDS || value == SALT_MARSH;
    }

    public static int register(Supplier<BiomeExtension> variants) {
        int index = BIOME_LAYER_INDEX.getAndIncrement();
        if (index >= BIOME_LAYERS.length) {
            throw new IllegalStateException("Tried to register layer id " + index + " but only had space for " + BIOME_LAYERS.length + " layers");
        }
        TFCLayers.BIOME_LAYERS[index] = Helpers.BOOTSTRAP_ENVIRONMENT ? null : variants.get();
        return index;
    }

    static {
        BIOME_LAYERS = new BiomeExtension[64];
        BIOME_LAYER_INDEX = new MutableInt(0);
        OCEAN = TFCLayers.register(() -> TFCBiomes.OCEAN);
        OCEAN_REEF = TFCLayers.register(() -> TFCBiomes.OCEAN_REEF);
        DEEP_OCEAN = TFCLayers.register(() -> TFCBiomes.DEEP_OCEAN);
        DEEP_OCEAN_TRENCH = TFCLayers.register(() -> TFCBiomes.DEEP_OCEAN_TRENCH);
        PLAINS = TFCLayers.register(() -> TFCBiomes.PLAINS);
        HILLS = TFCLayers.register(() -> TFCBiomes.HILLS);
        LOWLANDS = TFCLayers.register(() -> TFCBiomes.LOWLANDS);
        SALT_MARSH = TFCLayers.register(() -> TFCBiomes.SALT_MARSH);
        LOW_CANYONS = TFCLayers.register(() -> TFCBiomes.LOW_CANYONS);
        ROLLING_HILLS = TFCLayers.register(() -> TFCBiomes.ROLLING_HILLS);
        HIGHLANDS = TFCLayers.register(() -> TFCBiomes.HIGHLANDS);
        BADLANDS = TFCLayers.register(() -> TFCBiomes.BADLANDS);
        INVERTED_BADLANDS = TFCLayers.register(() -> TFCBiomes.INVERTED_BADLANDS);
        PLATEAU = TFCLayers.register(() -> TFCBiomes.PLATEAU);
        OLD_MOUNTAINS = TFCLayers.register(() -> TFCBiomes.OLD_MOUNTAINS);
        MOUNTAINS = TFCLayers.register(() -> TFCBiomes.MOUNTAINS);
        VOLCANIC_MOUNTAINS = TFCLayers.register(() -> TFCBiomes.VOLCANIC_MOUNTAINS);
        OCEANIC_MOUNTAINS = TFCLayers.register(() -> TFCBiomes.OCEANIC_MOUNTAINS);
        VOLCANIC_OCEANIC_MOUNTAINS = TFCLayers.register(() -> TFCBiomes.VOLCANIC_OCEANIC_MOUNTAINS);
        CANYONS = TFCLayers.register(() -> TFCBiomes.CANYONS);
        SHORE = TFCLayers.register(() -> TFCBiomes.SHORE);
        TIDAL_FLATS = TFCLayers.register(() -> TFCBiomes.TIDAL_FLATS);
        LAKE = TFCLayers.register(() -> TFCBiomes.LAKE);
        RIVER = TFCLayers.register(() -> TFCBiomes.RIVER);
        MOUNTAIN_LAKE = TFCLayers.register(() -> TFCBiomes.MOUNTAIN_LAKE);
        VOLCANIC_MOUNTAIN_LAKE = TFCLayers.register(() -> TFCBiomes.VOLCANIC_MOUNTAIN_LAKE);
        OLD_MOUNTAIN_LAKE = TFCLayers.register(() -> TFCBiomes.OLD_MOUNTAIN_LAKE);
        OCEANIC_MOUNTAIN_LAKE = TFCLayers.register(() -> TFCBiomes.OCEANIC_MOUNTAIN_LAKE);
        VOLCANIC_OCEANIC_MOUNTAIN_LAKE = TFCLayers.register(() -> TFCBiomes.VOLCANIC_OCEANIC_MOUNTAIN_LAKE);
        PLATEAU_LAKE = TFCLayers.register(() -> TFCBiomes.PLATEAU_LAKE);
    }
}

