/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.serialization.Codec;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.vein.IVein;
import net.dries007.tfc.world.feature.vein.PipeVeinConfig;
import net.dries007.tfc.world.feature.vein.VeinFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class PipeVeinFeature
extends VeinFeature<PipeVeinConfig, Vein> {
    public PipeVeinFeature(Codec<PipeVeinConfig> codec) {
        super(codec);
    }

    @Override
    protected float getChanceToGenerate(int x, int y, int z, Vein vein, PipeVeinConfig config) {
        double yScaled = (double)y / (double)config.height();
        x = (int)((double)x + (double)((float)vein.skew * vein.skewX) * yScaled);
        z = (int)((double)z + (double)((float)vein.skew * vein.skewZ) * yScaled);
        double yFactor = (double)vein.sign * yScaled + 0.5;
        double trueRadius = (double)config.radius() * (1.0 - yFactor) + (double)(config.radius() - vein.slant) * yFactor;
        if (Math.abs(y) < config.height() && (double)(x * x + z * z) < trueRadius * trueRadius) {
            return config.config().density();
        }
        return 0.0f;
    }

    @Override
    protected Vein createVein(WorldGenerationContext context, int chunkX, int chunkZ, RandomSource random, PipeVeinConfig config) {
        float angle = random.m_188501_() * (float)Math.PI * 2.0f;
        return new Vein(this.defaultPos(chunkX, chunkZ, random, config), config.sign() < random.m_188501_() ? 1 : -1, Mth.m_14089_((float)angle), Mth.m_14031_((float)angle), Helpers.uniform(random, config.minSkew(), 1 + config.maxSkew()), Helpers.uniform(random, config.minSlant(), 1 + config.maxSlant()));
    }

    @Override
    protected BoundingBox getBoundingBox(PipeVeinConfig config, Vein vein) {
        int radius = config.radius();
        int skew = vein.skew;
        return new BoundingBox(-radius - skew, -config.height(), -radius - skew, radius + skew, config.height(), radius + skew);
    }

    record Vein(BlockPos pos, int sign, float skewX, float skewZ, int skew, int slant) implements IVein
    {
    }
}

