/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import net.dries007.tfc.world.feature.tree.StackedTreeConfig;
import net.dries007.tfc.world.feature.tree.TreeHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class StackedTreeFeature
extends Feature<StackedTreeConfig> {
    public StackedTreeFeature(Codec<StackedTreeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<StackedTreeConfig> context) {
        boolean placeTree;
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        StackedTreeConfig config = (StackedTreeConfig)context.m_159778_();
        ChunkPos chunkPos = new ChunkPos(pos);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        StructureTemplateManager manager = TreeHelpers.getStructureManager(level);
        StructurePlaceSettings settings = TreeHelpers.getPlacementSettings((LevelHeightAccessor)level, chunkPos, random);
        if (TreeHelpers.isValidGround((LevelAccessor)level, pos, settings, config.placement()) && (placeTree = config.rootSystem().map(roots -> TreeHelpers.placeRoots(level, pos.m_7495_(), roots, random) || !roots.required()).orElse(true).booleanValue())) {
            config.rootSystem().ifPresent(roots -> TreeHelpers.placeRoots(level, pos.m_7495_(), roots, random));
            int trunkHeight = TreeHelpers.placeTrunk(level, (BlockPos)mutablePos, random, settings, config.trunk());
            mutablePos.m_122184_(0, trunkHeight, 0);
            for (StackedTreeConfig.Layer layer : config.layers()) {
                int layerCount = layer.getCount(random);
                for (int i = 0; i < layerCount; ++i) {
                    ResourceLocation structureId = layer.templates().get(random.m_188503_(layer.templates().size()));
                    StructureTemplate structure = manager.m_230359_(structureId);
                    TreeHelpers.placeTemplate(structure, settings, (ServerLevelAccessor)level, mutablePos.m_121996_((Vec3i)TreeHelpers.transformCenter(structure.m_163801_(), settings)));
                    mutablePos.m_122184_(0, structure.m_163801_().m_123342_(), 0);
                }
            }
            return true;
        }
        return false;
    }
}

