/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import net.dries007.tfc.world.feature.tree.OverlayTreeConfig;
import net.dries007.tfc.world.feature.tree.TreeHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class OverlayTreeFeature
extends Feature<OverlayTreeConfig> {
    public OverlayTreeFeature(Codec<OverlayTreeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<OverlayTreeConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        OverlayTreeConfig config = (OverlayTreeConfig)context.m_159778_();
        ChunkPos chunkPos = new ChunkPos(pos);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        StructureTemplateManager manager = TreeHelpers.getStructureManager(level);
        StructurePlaceSettings settings = TreeHelpers.getPlacementSettings((LevelHeightAccessor)level, chunkPos, random);
        StructureTemplate structureBase = manager.m_230359_(config.base());
        StructureTemplate structureOverlay = manager.m_230359_(config.overlay());
        if (TreeHelpers.isValidLocation((LevelAccessor)level, pos, settings, config.placement())) {
            boolean placeTree = config.rootSystem().map(roots -> TreeHelpers.placeRoots(level, pos.m_7495_(), roots, random) || !roots.required()).orElse(true);
            if (placeTree) {
                config.trunk().ifPresent(trunk -> {
                    int height = TreeHelpers.placeTrunk(level, (BlockPos)mutablePos, random, settings, trunk);
                    mutablePos.m_122184_(0, height, 0);
                });
                TreeHelpers.placeTemplate(structureBase, settings, (ServerLevelAccessor)level, mutablePos.m_121996_((Vec3i)TreeHelpers.transformCenter(structureBase.m_163801_(), settings)));
                settings.m_74383_((StructureProcessor)new BlockRotProcessor(config.overlayIntegrity()));
                TreeHelpers.placeTemplate(structureOverlay, settings, (ServerLevelAccessor)level, mutablePos.m_121996_((Vec3i)TreeHelpers.transformCenter(structureOverlay.m_163801_(), settings)));
                return true;
            }
            return false;
        }
        return false;
    }
}

