/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.dries007.tfc.common.blocks.soil.IGrassBlock;
import net.dries007.tfc.common.blocks.wood.ILeavesBlock;
import net.dries007.tfc.world.feature.FloodFillLakeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;

public class FloodFillLakeFeature
extends Feature<FloodFillLakeConfig> {
    public FloodFillLakeFeature(Codec<FloodFillLakeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FloodFillLakeConfig> context) {
        WorldGenLevel worldIn = context.m_159774_();
        BlockPos pos = context.m_159777_();
        FloodFillLakeConfig config = (FloodFillLakeConfig)context.m_159778_();
        ChunkPos chunkPos = new ChunkPos(pos);
        BoundingBox box = new BoundingBox(chunkPos.m_45604_() - 14, Integer.MIN_VALUE, chunkPos.m_45605_() - 14, chunkPos.m_45608_() + 14, Integer.MAX_VALUE, chunkPos.m_45609_() + 14);
        HashSet<BlockPos> filled = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.m_122190_((Vec3i)pos);
        while (worldIn.m_46859_((BlockPos)mutablePos) && mutablePos.m_123342_() > 11) {
            mutablePos.m_122184_(0, -1, 0);
        }
        pos = mutablePos.m_7949_();
        BlockPos startPos = pos.m_7494_();
        BlockState fill = config.getState();
        Fluid fluid = fill.m_60819_().m_76152_();
        if (this.floodFill(worldIn, startPos, box, filled, mutablePos, config) && filled.size() >= 20) {
            for (BlockPos filledPos : filled) {
                BlockState stateDown;
                worldIn.m_7731_(filledPos, fill, 2);
                worldIn.m_186469_(filledPos, fluid, 0);
                mutablePos.m_122190_((Vec3i)filledPos).m_122184_(0, -1, 0);
                if (filled.contains(mutablePos) || !((stateDown = worldIn.m_8055_((BlockPos)mutablePos)).m_60734_() instanceof IGrassBlock)) continue;
                BlockState dirtState = ((IGrassBlock)stateDown.m_60734_()).getDirt();
                worldIn.m_7731_((BlockPos)mutablePos, dirtState, 2);
            }
            return true;
        }
        return false;
    }

    private boolean floodFill(WorldGenLevel worldIn, BlockPos startPos, BoundingBox box, Set<BlockPos> filled, BlockPos.MutableBlockPos mutablePos, FloodFillLakeConfig config) {
        boolean result = this.floodFillLayer(worldIn, startPos, box, filled, mutablePos, config);
        if (!result) {
            return false;
        }
        if (!config.shouldOverfill()) {
            return true;
        }
        HashSet<BlockPos> nextFilled = new HashSet<BlockPos>(filled);
        startPos = startPos.m_7494_();
        int prevSize = filled.size();
        while (this.floodFillLayer(worldIn, startPos, box, nextFilled, mutablePos, config)) {
            filled.addAll(nextFilled);
            if (prevSize == filled.size()) {
                return true;
            }
            startPos = startPos.m_7494_();
        }
        return true;
    }

    private boolean floodFillLayer(WorldGenLevel worldIn, BlockPos startPos, BoundingBox box, Set<BlockPos> filled, BlockPos.MutableBlockPos mutablePos, FloodFillLakeConfig config) {
        if (!this.isFloodFillable(worldIn.m_8055_(startPos), config)) {
            return false;
        }
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        Direction[] directions = Direction.values();
        int maximumY = startPos.m_123342_();
        filled.add(startPos);
        queue.addFirst(startPos);
        while (!queue.isEmpty()) {
            BlockPos posAt = (BlockPos)queue.removeFirst();
            for (Direction direction : directions) {
                BlockState stateAt;
                mutablePos.m_122190_((Vec3i)posAt).m_122173_(direction);
                if (filled.contains(mutablePos) || mutablePos.m_123342_() > maximumY || !this.isFloodFillable(stateAt = worldIn.m_8055_((BlockPos)mutablePos), config)) continue;
                if (box.m_71051_((Vec3i)mutablePos)) {
                    BlockPos posNext = mutablePos.m_7949_();
                    queue.addFirst(posNext);
                    filled.add(posNext);
                    continue;
                }
                return false;
            }
        }
        return !filled.isEmpty();
    }

    private boolean isFloodFillable(BlockState state, FloodFillLakeConfig config) {
        return !state.m_280296_() && !(state.m_60734_() instanceof ILeavesBlock) && config.shouldReplace(state.m_60819_().m_76152_());
    }
}

