/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.dries007.tfc.world.Codecs;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FloodFillLakeConfig
implements FeatureConfiguration {
    public static final Codec<FloodFillLakeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.BLOCK_STATE.fieldOf("state").forGetter(FloodFillLakeConfig::getState), (App)Codecs.FLUID.listOf().fieldOf("replace_fluids").forGetter(c -> new ArrayList<Fluid>(c.replaceFluids)), (App)Codec.BOOL.optionalFieldOf("overfill", (Object)false).forGetter(FloodFillLakeConfig::shouldOverfill)).apply((Applicative)instance, FloodFillLakeConfig::new));
    private final BlockState state;
    private final Set<Fluid> replaceFluids;
    private final boolean overfill;

    public FloodFillLakeConfig(BlockState state, List<Fluid> replaceFluids, boolean overfill) {
        this.state = state;
        this.replaceFluids = new HashSet<Fluid>(replaceFluids);
        this.overfill = overfill;
    }

    public boolean shouldOverfill() {
        return this.overfill;
    }

    public boolean shouldReplace(Fluid fluid) {
        return fluid == Fluids.f_76191_ || this.replaceFluids.contains(fluid);
    }

    public BlockState getState() {
        return this.state;
    }
}

