/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import net.dries007.tfc.world.chunkdata.ChunkDataGenerator;
import net.dries007.tfc.world.chunkdata.ChunkRockDataCache;
import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public class RockData {
    @Nullable
    private final ChunkDataGenerator generator;
    private int @Nullable [] surfaceHeight;
    @Nullable
    private ChunkRockDataCache cache;

    public RockData(@Nullable ChunkDataGenerator generator) {
        this.generator = generator;
        this.surfaceHeight = null;
        this.cache = null;
    }

    public void useCache(ChunkPos pos) {
        this.cache = new ChunkRockDataCache(pos);
    }

    public RockSettings getSurfaceRock(int x, int z) {
        assert (this.generator != null);
        return this.generator.generateRock(x, 0, z, 0, this.cache);
    }

    public RockSettings getRock(BlockPos pos) {
        return this.getRock(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public RockSettings getRock(int x, int y, int z) {
        assert (this.generator != null && this.surfaceHeight != null);
        return this.generator.generateRock(x, y, z, this.surfaceHeight[Units.index(x, z)], this.cache);
    }

    public int[] getSurfaceHeight() {
        assert (this.surfaceHeight != null);
        return this.surfaceHeight;
    }

    public void setSurfaceHeight(int[] surfaceHeight) {
        this.surfaceHeight = surfaceHeight;
    }
}

