/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionPartition;
import net.dries007.tfc.world.region.Units;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class RegionBiomeSource
extends BiomeSource
implements BiomeSourceExtension {
    public static final DeferredRegister<Codec<? extends BiomeSource>> BIOME_SOURCE = DeferredRegister.create((ResourceKey)Registries.f_256826_, (String)"tfc");
    public static final Codec<RegionBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_255175_((ResourceKey)Registries.f_256952_)).apply((Applicative)instance, RegionBiomeSource::new));
    private final HolderGetter<Biome> biomeRegistry;
    private RegionGenerator regionGenerator;
    private ConcurrentArea<BiomeExtension> biomeLayer;

    public RegionBiomeSource(HolderGetter<Biome> biomeRegistry) {
        this.biomeRegistry = biomeRegistry;
    }

    @Override
    public BiomeExtension getBiomeExtensionNoRiver(int quartX, int quartZ) {
        return this.biomeLayer.get(quartX, quartZ);
    }

    @Override
    public Holder<Biome> getBiomeFromExtension(BiomeExtension extension) {
        return this.biomeRegistry.m_255043_(extension.key());
    }

    @Override
    public RegionPartition.Point getPartition(int blockX, int blockZ) {
        return this.regionGenerator.getOrCreatePartitionPoint(Units.blockToGrid(blockX), Units.blockToGrid(blockZ));
    }

    @Override
    public void initRandomState(RegionGenerator regionGenerator, ConcurrentArea<BiomeExtension> biomeLayer) {
        this.regionGenerator = regionGenerator;
        this.biomeLayer = biomeLayer;
    }

    @Override
    public BiomeSourceExtension copy() {
        return new RegionBiomeSource(this.biomeRegistry);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return TFCBiomes.getAllKeys().stream().map(arg_0 -> this.biomeRegistry.m_255043_(arg_0));
    }

    public Holder<Biome> m_203407_(int quartX, int quartY, int quartZ, @Nullable Climate.Sampler sampler) {
        return this.getBiome(quartX, quartZ);
    }

    static {
        BIOME_SOURCE.register("overworld", () -> CODEC);
    }
}

