/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.dries007.tfc.mixin.accessor.ChunkAccessAccessor;
import net.dries007.tfc.mixin.accessor.ChunkGeneratorAccessor;
import net.dries007.tfc.mixin.accessor.ChunkMapAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.ChunkBaseBlockSource;
import net.dries007.tfc.world.ChunkBiomeSampler;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.ChunkHeightFiller;
import net.dries007.tfc.world.ChunkNoiseFiller;
import net.dries007.tfc.world.FastConcurrentCache;
import net.dries007.tfc.world.NoopClimateSampler;
import net.dries007.tfc.world.RandomStateExtension;
import net.dries007.tfc.world.TFCAquifer;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.chunkdata.RegionChunkDataGenerator;
import net.dries007.tfc.world.chunkdata.RockData;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.AreaFactory;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.noise.ChunkNoiseSamplingSettings;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.NoiseSampler;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.river.RiverBlendType;
import net.dries007.tfc.world.river.RiverNoiseSampler;
import net.dries007.tfc.world.settings.Settings;
import net.dries007.tfc.world.surface.SurfaceManager;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class TFCChunkGenerator
extends ChunkGenerator
implements ChunkGeneratorExtension {
    public static final Codec<TFCChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.comapFlatMap(TFCChunkGenerator::guardBiomeSource, BiomeSourceExtension::self).fieldOf("biome_source").forGetter(c -> c.customBiomeSource), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(c -> c.noiseSettings), (App)Settings.CODEC.fieldOf("tfc_settings").forGetter(c -> c.settings)).apply((Applicative)instance, TFCChunkGenerator::new));
    public static final DeferredRegister<Codec<? extends ChunkGenerator>> CHUNK_GENERATOR = DeferredRegister.create((ResourceKey)Registries.f_256783_, (String)"tfc");
    public static final int DECORATION_STEPS = GenerationStep.Decoration.values().length;
    public static final int SEA_LEVEL_Y = 63;
    private final BiomeSourceExtension customBiomeSource;
    private final Holder<NoiseGeneratorSettings> noiseSettings;
    private Settings settings;
    private final NoiseBasedChunkGenerator stupidMojangChunkGenerator;
    private final FastConcurrentCache<TFCAquifer> aquiferCache;
    private ChunkDataProvider chunkDataProvider;
    private long noiseSamplerSeed;
    private SurfaceManager surfaceManager;
    private NoiseSampler noiseSampler;

    private static DataResult<BiomeSourceExtension> guardBiomeSource(BiomeSource source) {
        DataResult dataResult;
        if (source instanceof BiomeSourceExtension) {
            BiomeSourceExtension s = (BiomeSourceExtension)source;
            dataResult = DataResult.success((Object)s);
        } else {
            dataResult = DataResult.error(() -> "Must be a " + BiomeSourceExtension.class.getSimpleName());
        }
        return dataResult;
    }

    public TFCChunkGenerator(BiomeSourceExtension biomeSource, Holder<NoiseGeneratorSettings> noiseSettings, Settings settings) {
        super(biomeSource.self());
        this.noiseSettings = noiseSettings;
        this.customBiomeSource = biomeSource;
        this.settings = settings;
        this.stupidMojangChunkGenerator = new NoiseBasedChunkGenerator(biomeSource.self(), noiseSettings);
        this.aquiferCache = new FastConcurrentCache(256);
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public void applySettings(UnaryOperator<Settings> settings) {
        this.settings = (Settings)settings.apply(this.settings);
    }

    @Override
    public ChunkDataProvider chunkDataProvider() {
        return this.chunkDataProvider;
    }

    @Override
    public Aquifer getOrCreateAquifer(ChunkAccess chunk) {
        ChunkNoiseSamplingSettings settings = this.createNoiseSamplingSettingsForChunk(chunk);
        ChunkBaseBlockSource baseBlockSource = this.createBaseBlockSourceForChunk(chunk);
        return this.getOrCreateAquifer(chunk, settings, baseBlockSource);
    }

    @Override
    public void initRandomState(ChunkMap chunkMap, ServerLevel level) {
        if (this.chunkDataProvider != null) {
            TFCChunkGenerator copy = this.copy();
            ((ChunkMapAccessor)chunkMap).accessor$setGenerator(copy);
            copy.initRandomState(chunkMap, level);
            return;
        }
        long seed = level.m_7328_();
        XoroshiroRandomSource random = new XoroshiroRandomSource(seed);
        RegionGenerator regionGenerator = new RegionGenerator(this.settings, (RandomSource)random);
        RegionChunkDataGenerator chunkDataGenerator = RegionChunkDataGenerator.create(random.m_188505_(), this.settings.rockLayerSettings(), regionGenerator);
        AreaFactory factory = TFCLayers.createRegionBiomeLayer(regionGenerator, random.m_188505_());
        ConcurrentArea<BiomeExtension> biomeLayer = new ConcurrentArea<BiomeExtension>(factory, TFCLayers::getFromLayerId);
        this.noiseSamplerSeed = seed;
        this.noiseSampler = new NoiseSampler(random.m_188505_(), (HolderGetter<NormalNoise.NoiseParameters>)level.m_9598_().m_255025_(Registries.f_256865_), (HolderGetter<DensityFunction>)level.m_9598_().m_255025_(Registries.f_257040_));
        this.chunkDataProvider = new ChunkDataProvider(chunkDataGenerator);
        this.surfaceManager = new SurfaceManager(seed);
        this.customBiomeSource.initRandomState(regionGenerator, biomeLayer);
        ((RandomStateExtension)((ChunkMapAccessor)chunkMap).accessor$getRandomState()).tfc$setChunkGeneratorExtension(this);
    }

    public ChunkHeightFiller createHeightFillerForChunk(ChunkPos pos) {
        Object2DoubleMap<BiomeExtension>[] biomeWeights = ChunkBiomeSampler.sampleBiomes(pos, this::sampleBiomeNoRiver, BiomeExtension::biomeBlendType);
        return new ChunkHeightFiller(biomeWeights, this.customBiomeSource, this.createBiomeSamplersForChunk(null), this.createRiverSamplersForChunk(), this.createShoreSamplerForChunk(), this.m_6337_());
    }

    protected Codec<TFCChunkGenerator> m_6909_() {
        return CODEC;
    }

    public CompletableFuture<ChunkAccess> m_213908_(Executor executor, RandomState state, Blender legacyTerrainBlender, StructureManager structureFeatureManager, ChunkAccess chunk) {
        return CompletableFuture.supplyAsync(() -> {
            this.chunkDataProvider.get(chunk);
            chunk.m_183442_((quartX, quartY, quartZ, sampler) -> this.customBiomeSource.getBiome(quartX, quartZ), NoopClimateSampler.INSTANCE);
            return chunk;
        }, Util.m_183991_());
    }

    public void m_213679_(WorldGenRegion level, long seed, RandomState state, BiomeManager biomeManager, StructureManager structureFeatureManager, ChunkAccess chunk, GenerationStep.Carving step) {
        if (step != GenerationStep.Carving.AIR) {
            return;
        }
        BiomeManager customBiomeManager = biomeManager.m_186687_((x, y, z) -> this.customBiomeSource.getBiome(x, z));
        PositionalRandomFactory fork = new XoroshiroRandomSource(seed).m_188582_();
        ChunkPos chunkPos = chunk.m_7697_();
        ChunkNoiseSamplingSettings settings = this.createNoiseSamplingSettingsForChunk(chunk);
        ChunkBaseBlockSource baseBlockSource = this.createBaseBlockSourceForChunk(chunk);
        TFCAquifer aquifer = this.getOrCreateAquifer(chunk, settings, baseBlockSource);
        CarvingContext context = new CarvingContext(this.stupidMojangChunkGenerator, null, chunk.m_183618_(), null, state, ((NoiseGeneratorSettings)this.noiseSettings.m_203334_()).f_188871_());
        CarvingMask carvingMask = ((ProtoChunk)chunk).m_183613_(step);
        for (int offsetX = -8; offsetX <= 8; ++offsetX) {
            for (int offsetZ = -8; offsetZ <= 8; ++offsetZ) {
                ChunkPos offsetChunkPos = new ChunkPos(chunkPos.f_45578_ + offsetX, chunkPos.f_45579_ + offsetZ);
                ChunkAccess offsetChunk = level.m_6325_(offsetChunkPos.f_45578_, offsetChunkPos.f_45579_);
                Iterable iterable = offsetChunk.m_223014_(() -> ((Biome)this.customBiomeSource.getBiome(QuartPos.m_175400_((int)offsetChunkPos.m_45604_()), QuartPos.m_175400_((int)offsetChunkPos.m_45605_())).m_203334_()).m_47536_()).m_204187_(step);
                int i = 1;
                for (Holder holder : iterable) {
                    RandomSource chunkRandom = fork.m_213715_(offsetChunkPos.f_45578_, i, offsetChunkPos.f_45579_);
                    ConfiguredWorldCarver carver = (ConfiguredWorldCarver)holder.m_203334_();
                    if (carver.m_224896_(chunkRandom)) {
                        carver.m_224898_(context, chunk, arg_0 -> ((BiomeManager)customBiomeManager).m_204214_(arg_0), chunkRandom, (Aquifer)aquifer, offsetChunkPos, carvingMask);
                    }
                    ++i;
                }
            }
        }
    }

    public void m_213609_(WorldGenLevel level, ChunkAccess chunk, StructureManager structureFeatureManager) {
        ChunkPos chunkPos = chunk.m_7697_();
        SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)level.m_151560_());
        BlockPos originPos = sectionPos.m_123249_();
        Registry structureFeatures = level.m_9598_().m_175515_(Registries.f_256944_);
        Map<Integer, List<Structure>> structureFeaturesByStep = structureFeatures.m_123024_().collect(Collectors.groupingBy(feature -> feature.m_226619_().ordinal()));
        List<FeatureSorter.StepFeatureData> orderedFeatures = ((ChunkGeneratorAccessor)((Object)this)).accessor$getFeaturesPerStep().get();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));
        long baseSeed = Helpers.hash(128739412341L, originPos);
        ObjectArraySet allAdjacentBiomes = new ObjectArraySet();
        ChunkPos.m_45596_((ChunkPos)sectionPos.m_123251_(), (int)1).forEach(arg_0 -> TFCChunkGenerator.lambda$applyBiomeDecoration$12(level, (Set)allAdjacentBiomes, arg_0));
        for (int decorationIndex = 0; decorationIndex < Math.max(DECORATION_STEPS, orderedFeatures.size()); ++decorationIndex) {
            if (structureFeatureManager.m_220467_()) {
                int featureIndex = 0;
                for (Structure feature2 : structureFeaturesByStep.getOrDefault(decorationIndex, Collections.emptyList())) {
                    Helpers.seedLargeFeatures((RandomSource)random, baseSeed, featureIndex, decorationIndex);
                    structureFeatureManager.m_220504_(sectionPos, feature2).forEach(start -> start.m_226850_(level, structureFeatureManager, (ChunkGenerator)this, (RandomSource)random, this.getBoundingBoxForStructure(chunk), chunkPos));
                    ++featureIndex;
                }
            }
            if (decorationIndex >= orderedFeatures.size()) continue;
            IntArraySet featureIndices = new IntArraySet();
            for (Biome biome : allAdjacentBiomes) {
                List<HolderSet<PlacedFeature>> featuresPerBiome = TFCBiomes.getExtensionOrThrow((LevelAccessor)level, biome).getFlattenedFeatures(biome);
                if (decorationIndex >= featuresPerBiome.size()) continue;
                HolderSet<PlacedFeature> featuresPerBiomeAtStep = featuresPerBiome.get(decorationIndex);
                FeatureSorter.StepFeatureData stepIndex = orderedFeatures.get(decorationIndex);
                for (Holder holder : featuresPerBiomeAtStep) {
                    featureIndices.add(stepIndex.f_220625_().applyAsInt((PlacedFeature)holder.m_203334_()));
                }
            }
            int[] sortedIndices = featureIndices.toIntArray();
            FeatureSorter.StepFeatureData step = orderedFeatures.get(decorationIndex);
            Arrays.sort(sortedIndices);
            for (int featureIndex : sortedIndices) {
                Helpers.seedLargeFeatures((RandomSource)random, baseSeed, featureIndex, decorationIndex);
                ((PlacedFeature)step.f_220624_().get(featureIndex)).m_226377_(level, (ChunkGenerator)this, (RandomSource)random, originPos);
            }
        }
        level.m_143497_(null);
    }

    public void m_214194_(WorldGenRegion level, StructureManager structureFeatureManager, RandomState state, ChunkAccess chunk) {
        this.makeBedrock(chunk);
    }

    public void m_6929_(WorldGenRegion level) {
        if (!((NoiseGeneratorSettings)this.noiseSettings.m_203334_()).f_64445_()) {
            ChunkPos pos = level.m_143488_();
            Holder biome = level.m_204166_(pos.m_45615_().m_175288_(level.m_151558_() - 1));
            WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));
            random.m_64690_(level.m_7328_(), pos.m_45604_(), pos.m_45605_());
            NaturalSpawner.m_220450_((ServerLevelAccessor)level, (Holder)biome, (ChunkPos)pos, (RandomSource)random);
        }
    }

    public BiomeSource m_62218_() {
        return this.customBiomeSource.self();
    }

    public int m_6331_() {
        return ((NoiseGeneratorSettings)this.noiseSettings.m_203334_()).f_64439_().f_64508_();
    }

    public void m_255037_(RegistryAccess dynamicRegistry, ChunkGeneratorStructureState structureState, StructureManager structureFeatureManager, ChunkAccess chunk, StructureTemplateManager templateManager) {
        this.chunkDataProvider.get(chunk);
        super.m_255037_(dynamicRegistry, structureState, structureFeatureManager, chunk, templateManager);
    }

    public void m_223076_(WorldGenLevel level, StructureManager structureFeatureManager, ChunkAccess chunk) {
        super.m_223076_(level, structureFeatureManager, chunk);
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor mainExecutor, Blender oldTerrainBlender, RandomState rawState, StructureManager structureFeatureManager, ChunkAccess chunk) {
        ChunkNoiseSamplingSettings settings = this.createNoiseSamplingSettingsForChunk(chunk);
        LevelAccessor actualLevel = (LevelAccessor)((ChunkAccessAccessor)chunk).accessor$getLevelHeightAccessor();
        ChunkPos chunkPos = chunk.m_7697_();
        XoroshiroRandomSource random = new XoroshiroRandomSource((long)chunkPos.f_45578_ * 1842639486192314L, (long)chunkPos.f_45579_ * 579238196380231L);
        ChunkData chunkData = this.chunkDataProvider.get(chunk);
        HashSet<LevelChunkSection> sections = new HashSet<LevelChunkSection>();
        for (LevelChunkSection section : chunk.m_7103_()) {
            section.m_62981_();
            sections.add(section);
        }
        Object2DoubleMap<BiomeExtension>[] biomeWeights = ChunkBiomeSampler.sampleBiomes(chunkPos, this::sampleBiomeNoRiver, BiomeExtension::biomeBlendType);
        ChunkBaseBlockSource baseBlockSource = this.createBaseBlockSourceForChunk(chunk);
        ChunkNoiseFiller filler = new ChunkNoiseFiller((ProtoChunk)chunk, biomeWeights, this.customBiomeSource, this.createBiomeSamplersForChunk(chunk), this.createRiverSamplersForChunk(), this.createShoreSamplerForChunk(), this.noiseSampler, baseBlockSource, settings, this.m_6337_(), Beardifier.m_223937_((StructureManager)structureFeatureManager, (ChunkPos)chunkPos));
        return CompletableFuture.supplyAsync(() -> {
            filler.sampleAquiferSurfaceHeight(this::sampleBiomeNoRiver);
            chunkData.generateFull(filler.surfaceHeight(), filler.aquifer().surfaceHeights());
            chunkData.getRockData().useCache(chunkPos);
            filler.fillFromNoise();
            this.aquiferCache.set(chunkPos.f_45578_, chunkPos.f_45579_, filler.aquifer());
            return chunk;
        }, Util.m_183991_()).whenCompleteAsync((arg_0, arg_1) -> this.lambda$fillFromNoise$15(sections, actualLevel, chunk, chunkData, filler, (RandomSource)random, settings, arg_0, arg_1), mainExecutor);
    }

    public int m_6337_() {
        return 63;
    }

    public int m_142062_() {
        return ((NoiseGeneratorSettings)this.noiseSettings.m_203334_()).f_64439_().f_158688_();
    }

    public int m_214096_(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState state) {
        ChunkPos pos = new ChunkPos(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z));
        return (int)this.createHeightFillerForChunk(pos).sampleHeight(x, z);
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor level, RandomState state) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void m_213600_(List<String> list, RandomState state, BlockPos pos) {
        list.add("Shore: " + this.createShoreSamplerForChunk().noise(pos.m_123341_(), pos.m_123343_()));
    }

    private void makeBedrock(ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        XoroshiroRandomSource random = new XoroshiroRandomSource((long)chunkPos.f_45578_ * 2369412341L, (long)chunkPos.f_45579_ * 8192836412341L);
        LevelChunkSection bottomSection = chunk.m_183278_(0);
        BlockState bedrock = Blocks.f_50752_.m_49966_();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (this.settings.flatBedrock()) {
                    bottomSection.m_62991_(x, 0, z, bedrock, false);
                    continue;
                }
                for (int y = 0; y < 6; ++y) {
                    if (random.m_188503_(6) >= 6 - y) continue;
                    bottomSection.m_62991_(x, y, z, bedrock, false);
                }
            }
        }
    }

    private BoundingBox getBoundingBoxForStructure(ChunkAccess chunk) {
        ChunkPos pos = chunk.m_7697_();
        int blockX = pos.m_45604_();
        int blockZ = pos.m_45605_();
        LevelHeightAccessor level = chunk.m_183618_();
        return new BoundingBox(blockX, level.m_141937_() + 1, blockZ, blockX + 15, level.m_151558_() - 1, blockZ + 15);
    }

    private BiomeExtension sampleBiomeNoRiver(int blockX, int blockZ) {
        return this.customBiomeSource.getBiomeExtensionNoRiver(QuartPos.m_175400_((int)blockX), QuartPos.m_175400_((int)blockZ));
    }

    private ChunkBaseBlockSource createBaseBlockSourceForChunk(ChunkAccess chunk) {
        RockData rockData = this.chunkDataProvider.get(chunk).getRockData();
        return new ChunkBaseBlockSource(rockData, this::sampleBiomeNoRiver);
    }

    private ChunkNoiseSamplingSettings createNoiseSamplingSettingsForChunk(ChunkAccess chunk) {
        return this.createNoiseSamplingSettingsForChunk(chunk.m_7697_(), chunk.m_183618_());
    }

    private ChunkNoiseSamplingSettings createNoiseSamplingSettingsForChunk(ChunkPos pos, LevelHeightAccessor level) {
        NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.noiseSettings.m_203334_()).f_64439_();
        int cellWidth = noiseSettings.m_189213_();
        int cellHeight = noiseSettings.m_189212_();
        int minY = Math.max(noiseSettings.f_158688_(), level.m_141937_());
        int maxY = Math.min(noiseSettings.f_158688_() + noiseSettings.f_64508_(), level.m_151558_());
        int cellCountY = Math.floorDiv(maxY - minY, noiseSettings.m_189212_());
        int firstCellX = Math.floorDiv(pos.m_45604_(), cellWidth);
        int firstCellY = Math.floorDiv(minY, cellHeight);
        int firstCellZ = Math.floorDiv(pos.m_45605_(), cellWidth);
        return new ChunkNoiseSamplingSettings(minY, 16 / cellWidth, cellCountY, cellWidth, cellHeight, firstCellX, firstCellY, firstCellZ);
    }

    private TFCAquifer getOrCreateAquifer(ChunkAccess chunk, ChunkNoiseSamplingSettings settings, ChunkBaseBlockSource baseBlockSource) {
        ChunkPos chunkPos = chunk.m_7697_();
        TFCAquifer aquifer = this.aquiferCache.getIfPresent(chunkPos.f_45578_, chunkPos.f_45579_);
        if (aquifer == null) {
            ChunkData chunkData = this.chunkDataProvider.get(chunk);
            aquifer = new TFCAquifer(chunkPos, settings, baseBlockSource, this.m_6337_(), this.noiseSampler.positionalRandomFactory, this.noiseSampler.barrierNoise);
            aquifer.setSurfaceHeights(chunkData.getAquiferSurfaceHeight());
            this.aquiferCache.set(chunkPos.f_45578_, chunkPos.f_45579_, aquifer);
        }
        return aquifer;
    }

    private Map<BiomeExtension, BiomeNoiseSampler> createBiomeSamplersForChunk(@Nullable ChunkAccess chunk) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BiomeExtension extension : TFCBiomes.getExtensions()) {
            BiomeNoiseSampler sampler = extension.createNoiseSampler(this.noiseSamplerSeed);
            if (sampler == null) continue;
            sampler.prepare(this, chunk);
            builder.put((Object)extension, (Object)sampler);
        }
        return builder.build();
    }

    private Map<RiverBlendType, RiverNoiseSampler> createRiverSamplersForChunk() {
        EnumMap<RiverBlendType, RiverNoiseSampler> builder = new EnumMap<RiverBlendType, RiverNoiseSampler>(RiverBlendType.class);
        for (RiverBlendType blendType : RiverBlendType.ALL) {
            builder.put(blendType, blendType.createNoiseSampler(this.noiseSamplerSeed));
        }
        return builder;
    }

    private Noise2D createShoreSamplerForChunk() {
        return new OpenSimplex2D(this.noiseSamplerSeed).octaves(2).spread(0.003f).scaled(-0.1, 1.1);
    }

    private TFCChunkGenerator copy() {
        return new TFCChunkGenerator(this.customBiomeSource.copy(), this.noiseSettings, this.settings);
    }

    private /* synthetic */ void lambda$fillFromNoise$15(Set sections, LevelAccessor actualLevel, ChunkAccess chunk, ChunkData chunkData, ChunkNoiseFiller filler, RandomSource random, ChunkNoiseSamplingSettings settings, ChunkAccess ret, Throwable error) {
        sections.forEach(LevelChunkSection::m_63006_);
        this.surfaceManager.buildSurface(actualLevel, chunk, this.rockLayerSettings(), chunkData, filler.localBiomes(), filler.localBiomesNoRivers(), filler.localBiomeWeights(), filler.createSlopeMap(), random, this.m_6337_(), settings.minY());
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$12(WorldGenLevel level, Set allAdjacentBiomes, ChunkPos chunkPos1_) {
        ChunkAccess adjChunk = level.m_6325_(chunkPos1_.f_45578_, chunkPos1_.f_45579_);
        for (LevelChunkSection adjSection : adjChunk.m_7103_()) {
            adjSection.m_187996_().m_196879_(biome -> allAdjacentBiomes.add((Biome)biome.m_203334_()));
        }
    }

    static {
        CHUNK_GENERATOR.register("overworld", () -> CODEC);
    }
}

