/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.Map;
import net.dries007.tfc.common.fluids.RiverWaterFluid;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.ChunkBaseBlockSource;
import net.dries007.tfc.world.ChunkHeightFiller;
import net.dries007.tfc.world.MutableDensityFunctionContext;
import net.dries007.tfc.world.Sampler;
import net.dries007.tfc.world.TFCAquifer;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.noise.ChunkNoiseSamplingSettings;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.NoiseSampler;
import net.dries007.tfc.world.noise.TrilinearInterpolator;
import net.dries007.tfc.world.noise.TrilinearInterpolatorList;
import net.dries007.tfc.world.region.RegionPartition;
import net.dries007.tfc.world.region.RiverEdge;
import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.river.Flow;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.river.RiverBlendType;
import net.dries007.tfc.world.river.RiverInfo;
import net.dries007.tfc.world.river.RiverNoiseSampler;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class ChunkNoiseFiller
extends ChunkHeightFiller {
    public static final int[] EXTERIOR_POINTS = (int[])Util.m_137469_((Object)new int[66], array -> {
        int index = 0;
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                if (x >= 1 && z >= 1 && x <= 4 && z <= 4) continue;
                array[index++] = x;
                array[index++] = z;
            }
        }
    });
    public static final int EXTERIOR_POINTS_COUNT = EXTERIOR_POINTS.length >> 1;
    private final ProtoChunk chunk;
    private final int chunkMinX;
    private final int chunkMinZ;
    private final Heightmap oceanFloor;
    private final Heightmap worldSurface;
    private final CarvingMask airCarvingMask;
    private final Beardifier beardifier;
    private final MutableDensityFunctionContext mutableDensityFunctionContext;
    private final FluidState riverWater;
    @Nullable
    private final RiverInfo[] riverData;
    private final Flow[] riverFlows;
    private final ChunkNoiseSamplingSettings settings;
    private final TrilinearInterpolatorList interpolator;
    private final TrilinearInterpolator noiseCaves;
    private final TrilinearInterpolator noodleToggle;
    private final TrilinearInterpolator noodleThickness;
    private final TrilinearInterpolator noodleRidgeA;
    private final TrilinearInterpolator noodleRidgeB;
    private final TFCAquifer aquifer;
    private final ChunkBaseBlockSource baseBlockSource;
    private final int[] surfaceHeight;
    private final BiomeExtension[] localBiomes;
    private final BiomeExtension[] localBiomesNoRivers;
    private final double[] localBiomeWeights;
    private double cellDeltaX;
    private double cellDeltaZ;
    private int lastCellZ;

    public ChunkNoiseFiller(ProtoChunk chunk, Object2DoubleMap<BiomeExtension>[] sampledBiomeWeights, BiomeSourceExtension biomeSource, Map<BiomeExtension, BiomeNoiseSampler> biomeNoiseSamplers, Map<RiverBlendType, RiverNoiseSampler> riverNoiseSamplers, Noise2D shoreSampler, NoiseSampler sampler, ChunkBaseBlockSource baseBlockSource, ChunkNoiseSamplingSettings settings, int seaLevel, Beardifier beardifier) {
        super(sampledBiomeWeights, biomeSource, biomeNoiseSamplers, riverNoiseSamplers, shoreSampler, seaLevel);
        this.chunk = chunk;
        this.chunkMinX = chunk.m_7697_().m_45604_();
        this.chunkMinZ = chunk.m_7697_().m_45605_();
        this.oceanFloor = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        this.worldSurface = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        this.airCarvingMask = chunk.m_183613_(GenerationStep.Carving.AIR);
        this.beardifier = beardifier;
        this.mutableDensityFunctionContext = new MutableDensityFunctionContext(new BlockPos.MutableBlockPos());
        this.riverWater = ((RiverWaterFluid)TFCFluids.RIVER_WATER.get()).m_76145_();
        this.riverData = new RiverInfo[256];
        this.riverFlows = new Flow[25];
        this.sampleRiverData();
        this.settings = settings;
        this.interpolator = TrilinearInterpolatorList.create(settings);
        this.baseBlockSource = baseBlockSource;
        this.noiseCaves = this.interpolator.add(sampler.noiseCaves);
        this.noodleToggle = this.interpolator.add(sampler.noodleToggle);
        this.noodleThickness = this.interpolator.add(sampler.noodleThickness);
        this.noodleRidgeA = this.interpolator.add(sampler.noodleRidgeA);
        this.noodleRidgeB = this.interpolator.add(sampler.noodleRidgeB);
        this.aquifer = new TFCAquifer(chunk.m_7697_(), settings, baseBlockSource, seaLevel, sampler.positionalRandomFactory, sampler.barrierNoise);
        this.surfaceHeight = new int[256];
        this.localBiomes = new BiomeExtension[256];
        this.localBiomesNoRivers = new BiomeExtension[256];
        this.localBiomeWeights = new double[256];
    }

    public TFCAquifer aquifer() {
        return this.aquifer;
    }

    public int[] surfaceHeight() {
        return this.surfaceHeight;
    }

    public BiomeExtension[] localBiomes() {
        return this.localBiomes;
    }

    public BiomeExtension[] localBiomesNoRivers() {
        return this.localBiomesNoRivers;
    }

    public double[] localBiomeWeights() {
        return this.localBiomeWeights;
    }

    public void sampleAquiferSurfaceHeight(Sampler<BiomeExtension> biomeSampler) {
        int z;
        int x;
        boolean debugAquiferSurfaceHeight = false;
        double[] sampledHeight = new double[121];
        int[] aquiferSurfaceHeights = this.aquifer.surfaceHeights();
        for (x = 0; x < 11; ++x) {
            for (z = 0; z < 11; ++z) {
                BiomeNoiseSampler sampler;
                int actualX = this.chunkMinX - 32 + (x << 3);
                int actualZ = this.chunkMinZ - 32 + (z << 3);
                BiomeExtension biome = biomeSampler.get(actualX, actualZ);
                double aquiferSurfaceHeight = biome.getAquiferSurfaceHeight(sampler = (BiomeNoiseSampler)this.biomeNoiseSamplers.get(biome), actualX, actualZ);
                if (aquiferSurfaceHeight > (double)(this.seaLevel - 24) && this.sampleRiverDistSq(actualX, actualZ) < 225.0) {
                    aquiferSurfaceHeight = this.seaLevel - 24;
                }
                if (aquiferSurfaceHeight > (double)this.seaLevel) {
                    aquiferSurfaceHeight = 0.3 * (double)this.seaLevel + 0.7 * aquiferSurfaceHeight;
                }
                sampledHeight[x + 11 * z] = aquiferSurfaceHeight;
            }
        }
        for (x = 0; x < 4; ++x) {
            for (z = 0; z < 4; ++z) {
                double minAquiferSurfaceHeight = Double.MAX_VALUE;
                int xIndex = 1 + x << 1;
                int zIndex = 1 + z << 1;
                for (int dx = -2; dx <= 2; ++dx) {
                    for (int dz = -2; dz <= 2; ++dz) {
                        minAquiferSurfaceHeight = Math.min(minAquiferSurfaceHeight, sampledHeight[xIndex + dx + 11 * (zIndex + dz)]);
                    }
                }
                aquiferSurfaceHeights[x + 4 * z] = (int)minAquiferSurfaceHeight;
            }
        }
    }

    public double[] createSlopeMap() {
        int z;
        int x;
        int[] quartSurfaceHeight = new int[49];
        for (int x2 = 0; x2 < 4; ++x2) {
            for (int z2 = 0; z2 < 4; ++z2) {
                quartSurfaceHeight[x2 + 1 + 7 * (z2 + 1)] = this.surfaceHeight[(x2 << 2) + 16 * (z2 << 2)];
            }
        }
        for (int i = 0; i < EXTERIOR_POINTS_COUNT; ++i) {
            x = EXTERIOR_POINTS[i << 1];
            z = EXTERIOR_POINTS[i << 1 | 1];
            int x0 = this.chunkMinX + (x - 1 << 2);
            int z0 = this.chunkMinZ + (z - 1 << 2);
            this.setupColumn(x0, z0);
            quartSurfaceHeight[x + 7 * z] = (int)this.sampleColumnHeightAndBiome((Object2DoubleMap<BiomeExtension>)this.sampledBiomeWeights[x + z * 7], false);
        }
        double[] slopeMap = new double[36];
        for (x = 0; x < 6; ++x) {
            for (z = 0; z < 6; ++z) {
                double slope;
                double nw = quartSurfaceHeight[x + 0 + 7 * (z + 0)];
                double ne = quartSurfaceHeight[x + 1 + 7 * (z + 0)];
                double sw = quartSurfaceHeight[x + 0 + 7 * (z + 1)];
                double se = quartSurfaceHeight[x + 1 + 7 * (z + 1)];
                double center = (nw + ne + sw + se) / 4.0;
                slopeMap[x + 6 * z] = slope = Math.abs(nw - center) + Math.abs(ne - center) + Math.abs(sw - center) + Math.abs(se - center);
            }
        }
        return slopeMap;
    }

    public void fillFromNoise() {
        this.interpolator.initializeForFirstCellX();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int cellX = 0; cellX < this.settings.cellCountXZ(); ++cellX) {
            this.interpolator.advanceCellX(cellX);
            for (int cellZ = 0; cellZ < this.settings.cellCountXZ(); ++cellZ) {
                for (int localCellX = 0; localCellX < this.settings.cellWidth(); ++localCellX) {
                    this.blockX = this.chunkMinX + cellX * this.settings.cellWidth() + localCellX;
                    this.localX = this.blockX & 0xF;
                    this.cellDeltaX = (double)localCellX / (double)this.settings.cellWidth();
                    for (int localCellZ = 0; localCellZ < this.settings.cellWidth(); ++localCellZ) {
                        this.blockZ = this.chunkMinZ + cellZ * this.settings.cellWidth() + localCellZ;
                        this.lastCellZ = cellZ;
                        this.localZ = this.blockZ & 0xF;
                        this.cellDeltaZ = (double)localCellZ / (double)this.settings.cellWidth();
                        mutablePos.m_122178_(this.blockX, 0, this.blockZ);
                        this.fillColumn(mutablePos, cellX, cellZ);
                    }
                }
            }
            this.interpolator.swapSlices();
        }
    }

    private void fillColumn(BlockPos.MutableBlockPos cursor, int cellX, int cellZ) {
        boolean debugFillColumn = false;
        this.prepareColumnBiomeWeights();
        this.sampleColumnHeightAndBiome((Object2DoubleMap<BiomeExtension>)this.biomeWeights1, true);
        int localIndex = this.localX + 16 * this.localZ;
        int heightNoiseValue = this.surfaceHeight[localIndex];
        BiomeExtension localBiome = this.localBiomes[localIndex];
        Flow flow = localBiome.hasRivers() ? this.calculateFlowAt(cellX, cellZ) : Flow.NONE;
        int maxFilledY = 1 + Math.max(heightNoiseValue, this.seaLevel);
        int maxFilledCellY = Math.min(this.settings.cellCountY() - 1, 1 + Math.floorDiv(maxFilledY, this.settings.cellHeight()) - this.settings.firstCellY());
        int maxFilledSectionY = Math.min(this.chunk.m_151559_() - 1, 1 + this.chunk.m_151564_(maxFilledY));
        boolean topBlockPlaced = false;
        boolean topSolidBlockPlaced = false;
        LevelChunkSection section = this.chunk.m_183278_(maxFilledSectionY);
        int lastSectionIndex = maxFilledSectionY;
        for (int cellY = maxFilledCellY; cellY >= 0; --cellY) {
            this.interpolator.selectCellYZ(cellY, this.lastCellZ);
            this.interpolator.updateForXZ(this.cellDeltaX, this.cellDeltaZ);
            for (int localCellY = this.settings.cellHeight() - 1; localCellY >= 0; --localCellY) {
                int y = (this.settings.firstCellY() + cellY) * this.settings.cellHeight() + localCellY;
                if (y >= maxFilledY) continue;
                int localY = y & 0xF;
                int sectionIndex = this.chunk.m_151564_(y);
                if (lastSectionIndex != sectionIndex) {
                    section = this.chunk.m_183278_(sectionIndex);
                    lastSectionIndex = sectionIndex;
                }
                double cellDeltaY = (double)localCellY / (double)this.settings.cellHeight();
                this.interpolator.updateForY(cellDeltaY);
                double noise = this.calculateNoiseAtHeight(y, heightNoiseValue);
                BlockState state = this.calculateBlockStateAtNoise(y, noise);
                FluidState fluid = state.m_60819_();
                cursor.m_142448_(y);
                if (!state.m_60795_()) {
                    if (fluid.m_76152_() == Fluids.f_76193_ && flow != Flow.NONE && y >= Math.min(this.seaLevel - 4, heightNoiseValue)) {
                        section.m_62991_(this.localX, localY, this.localZ, ((FluidState)this.riverWater.m_61124_(RiverWaterFluid.FLOW, (Comparable)((Object)flow))).m_76188_(), false);
                    } else {
                        section.m_62991_(this.localX, localY, this.localZ, state, false);
                    }
                    if (this.aquifer.m_142203_() && !fluid.m_76178_()) {
                        this.chunk.m_8113_((BlockPos)cursor);
                    }
                }
                if (state.m_60795_()) {
                    if (!topSolidBlockPlaced) continue;
                    this.airCarvingMask.m_187585_(this.blockX, y, this.blockZ);
                    section.m_62991_(this.localX, localY, this.localZ, Blocks.f_50627_.m_49966_(), false);
                    continue;
                }
                if (!fluid.m_76178_()) {
                    if (!topBlockPlaced) {
                        topBlockPlaced = true;
                        this.worldSurface.m_64249_(this.localX, y, this.localZ, state);
                    }
                    if (!topSolidBlockPlaced) continue;
                    this.airCarvingMask.m_187585_(this.blockX, y, this.blockZ);
                    continue;
                }
                if (!topBlockPlaced) {
                    topBlockPlaced = true;
                    this.worldSurface.m_64249_(this.localX, y, this.localZ, state);
                }
                if (topSolidBlockPlaced) continue;
                topSolidBlockPlaced = true;
                this.oceanFloor.m_64249_(this.localX, y, this.localZ, state);
            }
        }
    }

    private double calculateNoiseAtHeight(int y, double heightNoiseValue) {
        double noise = 0.0;
        for (Object2DoubleMap.Entry entry : this.columnBiomeNoiseSamplers.object2DoubleEntrySet()) {
            BiomeNoiseSampler sampler = (BiomeNoiseSampler)entry.getKey();
            noise += sampler.noise(y) * entry.getDoubleValue();
        }
        double initialNoise = noise;
        noise = 0.0;
        for (RiverBlendType type : RiverBlendType.ALL) {
            double weight = this.riverBlendWeights[type.ordinal()];
            if (type == RiverBlendType.NONE) {
                noise += weight * initialNoise;
                continue;
            }
            if (!(weight > 0.0)) continue;
            RiverNoiseSampler sampler = (RiverNoiseSampler)this.riverNoiseSamplers.get((Object)type);
            noise += weight * sampler.noise(y, initialNoise);
        }
        noise = 0.4 - noise;
        if ((double)y > heightNoiseValue) {
            noise -= ((double)y - heightNoiseValue) * (double)0.2f;
        }
        return Mth.m_14008_((double)noise, (double)-1.0, (double)1.0);
    }

    private BlockState calculateBlockStateAtNoise(int y, double terrainNoise) {
        double terrainAndCaveNoise = terrainNoise;
        if (this.noodleToggle.sample() >= 0.0) {
            double thickness = Mth.m_144851_((double)this.noodleThickness.sample(), (double)-1.0, (double)1.0, (double)0.05, (double)0.1);
            double ridgeA = Math.abs(1.5 * this.noodleRidgeA.sample()) - thickness;
            double ridgeB = Math.abs(1.5 * this.noodleRidgeB.sample()) - thickness;
            double ridge = Math.max(ridgeA, ridgeB);
            terrainAndCaveNoise = Math.min(terrainAndCaveNoise, ridge);
        }
        terrainAndCaveNoise = Math.min(terrainAndCaveNoise, this.noiseCaves.sample());
        this.mutableDensityFunctionContext.cursor().m_122178_(this.blockX, y, this.blockZ);
        BlockState aquiferState = this.aquifer.sampleState(this.blockX, y, this.blockZ, terrainAndCaveNoise += this.beardifier.m_207386_((DensityFunction.FunctionContext)this.mutableDensityFunctionContext));
        if (aquiferState != null) {
            return aquiferState;
        }
        return this.baseBlockSource.getBaseBlock(this.blockX, y, this.blockZ);
    }

    @Override
    @Nullable
    protected RiverInfo sampleRiverInfo(boolean useCache) {
        return useCache ? this.riverData[this.localX + 16 * this.localZ] : this.sampleRiverEdge(this.biomeSource.getPartition(this.blockX, this.blockZ));
    }

    @Override
    protected void updateLocalCaches(Object2DoubleMap<BiomeExtension> biomeWeights, BiomeExtension biomeAt, @Nullable RiverInfo info, double height) {
        int localIndex = this.localX + 16 * this.localZ;
        this.localBiomesNoRivers[localIndex] = biomeAt;
        if (height <= 64.0 && info != null && info.normDistSq() < 1.1 && biomeAt.hasRivers()) {
            biomeAt = TFCBiomes.RIVER;
        }
        this.localBiomes[localIndex] = biomeAt;
        this.localBiomeWeights[localIndex] = biomeWeights.getOrDefault((Object)biomeAt, 0.5);
        this.surfaceHeight[localIndex] = (int)height;
        this.baseBlockSource.useAccurateBiome(this.localX, this.localZ, biomeAt);
    }

    private void sampleRiverData() {
        RegionPartition.Point point = this.biomeSource.getPartition(this.chunkMinX, this.chunkMinZ);
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                RiverInfo info;
                this.setupColumn(this.chunkMinX + localX, this.chunkMinZ + localZ);
                this.riverData[localX + 16 * localZ] = info = this.sampleRiverEdge(point);
            }
        }
        for (int quartX = 0; quartX < 5; ++quartX) {
            for (int quartZ = 0; quartZ < 5; ++quartZ) {
                RiverInfo info;
                int localX = quartX << 2;
                int localZ = quartZ << 2;
                if (quartX < 4 && quartZ < 4) {
                    info = this.riverData[localX + 16 * localZ];
                } else {
                    this.setupColumn(this.chunkMinX + localX, this.chunkMinZ + localZ);
                    info = this.sampleRiverEdge(point);
                }
                this.riverFlows[quartX + 5 * quartZ] = info != null && info.normDistSq() < 0.28 ? info.flow() : Flow.NONE;
            }
        }
    }

    private double sampleRiverDistSq(int blockX, int blockZ) {
        RegionPartition.Point point = this.biomeSource.getPartition(blockX, blockZ);
        double minDist = 3.4028234663852886E38;
        double exactGridX = Units.blockToGridExact(blockX);
        double exactGridZ = Units.blockToGridExact(blockZ);
        for (RiverEdge edge : point.rivers()) {
            double dist;
            MidpointFractal fractal = edge.fractal();
            if (!fractal.maybeIntersect(exactGridX, exactGridZ, minDist) || !((dist = fractal.intersectDistance(exactGridX, exactGridZ)) < minDist)) continue;
            minDist = dist;
        }
        return minDist * 128.0 * 128.0;
    }

    private Flow calculateFlowAt(int cellX, int cellZ) {
        Flow flow00 = this.riverFlows[cellX + 5 * cellZ];
        Flow flow10 = this.riverFlows[cellX + 5 * (cellZ + 1)];
        Flow flow01 = this.riverFlows[cellX + 1 + 5 * cellZ];
        Flow flow11 = this.riverFlows[cellX + 1 + 5 * (cellZ + 1)];
        return Flow.lerp(flow00, flow01, flow10, flow11, (float)this.cellDeltaX, (float)this.cellDeltaZ);
    }

    private void setPerColumnDebugStates() {
        RiverInfo river = this.riverData[this.localX + 16 * this.localZ];
        if (river != null) {
            int y = 130 + (int)(Math.sqrt(river.distSq() + (double)0.01f) * 0.5);
            if (y > 140) {
                y = 140;
            }
            this.setDebugState(y, Blocks.f_50210_);
            y = 150 + (int)(Math.sqrt(river.normDistSq() + (double)0.01f) * 10.0);
            if (y > 160) {
                y = 160;
            }
            this.setDebugState(y, Blocks.f_50202_);
        }
        if (this.localBiomes[this.localX + 16 * this.localZ] == TFCBiomes.RIVER) {
            this.setDebugState(120, Blocks.f_50202_);
        }
        if (this.chunk.m_203495_(this.localX >> 2, 120, this.localZ >> 2).m_203334_() == this.biomeSource.getBiomeFromExtension(TFCBiomes.RIVER).m_203334_()) {
            this.setDebugState(115, Blocks.f_50206_);
        }
    }

    private void setDebugState(int y, Block block) {
        this.chunk.m_183278_(this.chunk.m_151564_(y)).m_62991_(this.localX, y & 0xF, this.localZ, block.m_49966_(), false);
    }
}

