/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.ChunkBiomeSampler;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.region.RegionPartition;
import net.dries007.tfc.world.region.RiverEdge;
import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.river.Flow;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.river.RiverBlendType;
import net.dries007.tfc.world.river.RiverInfo;
import net.dries007.tfc.world.river.RiverNoiseSampler;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ChunkHeightFiller {
    protected static final int RIVER_TYPE_NONE = RiverBlendType.NONE.ordinal();
    protected static final int RIVER_TYPE_CAVE = RiverBlendType.CAVE.ordinal();
    protected final Map<BiomeExtension, BiomeNoiseSampler> biomeNoiseSamplers;
    protected final Object2DoubleMap<BiomeNoiseSampler> columnBiomeNoiseSamplers;
    protected final Object2DoubleMap<BiomeExtension>[] sampledBiomeWeights;
    protected final Object2DoubleMap<BiomeExtension> biomeWeights1;
    protected final BiomeSourceExtension biomeSource;
    protected final Map<RiverBlendType, RiverNoiseSampler> riverNoiseSamplers;
    protected final double[] riverBlendWeights;
    private final Noise2D shoreSampler;
    protected final int seaLevel;
    protected int blockX;
    protected int blockZ;
    protected int localX;
    protected int localZ;

    public ChunkHeightFiller(Object2DoubleMap<BiomeExtension>[] sampledBiomeWeights, BiomeSourceExtension biomeSource, Map<BiomeExtension, BiomeNoiseSampler> biomeNoiseSamplers, Map<RiverBlendType, RiverNoiseSampler> riverNoiseSamplers, Noise2D shoreSampler, int seaLevel) {
        this.biomeNoiseSamplers = biomeNoiseSamplers;
        this.columnBiomeNoiseSamplers = new Object2DoubleOpenHashMap();
        this.sampledBiomeWeights = sampledBiomeWeights;
        this.biomeWeights1 = new Object2DoubleOpenHashMap();
        this.biomeSource = biomeSource;
        this.riverNoiseSamplers = riverNoiseSamplers;
        this.riverBlendWeights = new double[RiverBlendType.SIZE];
        this.shoreSampler = shoreSampler;
        this.seaLevel = seaLevel;
    }

    public double sampleHeight(int blockX, int blockZ) {
        this.setupColumn(blockX, blockZ);
        this.prepareColumnBiomeWeights();
        return this.sampleColumnHeightAndBiome(this.biomeWeights1, false);
    }

    protected final void prepareColumnBiomeWeights() {
        ChunkBiomeSampler.sampleBiomesColumn(this.biomeWeights1, this.sampledBiomeWeights, this.localX, this.localZ);
    }

    protected final double sampleColumnHeightAndBiome(Object2DoubleMap<BiomeExtension> biomeWeights, boolean useCache) {
        this.columnBiomeNoiseSamplers.clear();
        double height = 0.0;
        double normalHeight = 0.0;
        double shoreHeight = 0.0;
        double shoreWeight = 0.0;
        BiomeExtension biomeAt = null;
        BiomeExtension normalBiomeAt = null;
        BiomeExtension shoreBiomeAt = null;
        double maxNormalWeight = 0.0;
        double maxShoreWeight = 0.0;
        for (Object2DoubleMap.Entry entry : biomeWeights.object2DoubleEntrySet()) {
            double biomeWeight = entry.getDoubleValue();
            BiomeExtension biome = (BiomeExtension)entry.getKey();
            BiomeNoiseSampler sampler = this.biomeNoiseSamplers.get(biome);
            assert (sampler != null) : "Non-existent sampler for biome: " + biome.key();
            if (this.columnBiomeNoiseSamplers.containsKey((Object)sampler)) {
                this.columnBiomeNoiseSamplers.mergeDouble((Object)sampler, biomeWeight, Double::sum);
            } else {
                sampler.setColumn(this.blockX, this.blockZ);
                this.columnBiomeNoiseSamplers.put((Object)sampler, biomeWeight);
            }
            double biomeHeight = biomeWeight * sampler.height();
            height += biomeHeight;
            if (biome.isShore()) {
                shoreHeight += biomeHeight;
                shoreWeight += biomeWeight;
                if (!(maxShoreWeight < biomeWeight)) continue;
                shoreBiomeAt = biome;
                maxShoreWeight = biomeWeight;
                continue;
            }
            normalHeight += biomeHeight;
            if (!(maxNormalWeight < biomeWeight)) continue;
            normalBiomeAt = biome;
            maxNormalWeight = biomeWeight;
        }
        biomeAt = normalBiomeAt;
        if (biomeAt == null) {
            biomeAt = shoreBiomeAt;
        }
        if (shoreWeight > 0.5 && shoreBiomeAt != null) {
            double normalWeight;
            double adjustedNormalWeight;
            double cliffInfluence = Mth.m_14008_((double)(this.shoreSampler.noise(this.blockX, this.blockZ) + Mth.m_144914_((double)height, (double)this.seaLevel, (double)(this.seaLevel + 20), (double)0.0, (double)0.6)), (double)0.0, (double)1.0);
            double adjustedCliffInfluence = 1.0 - (1.0 - cliffInfluence) * (1.0 - cliffInfluence);
            double x2 = Mth.m_14139_((double)adjustedCliffInfluence, (double)0.8, (double)0.515);
            double y2 = 1.15 - 0.3 * x2;
            double adjustedShoreWeight = shoreWeight < x2 ? Mth.m_144914_((double)shoreWeight, (double)0.5, (double)x2, (double)0.5, (double)y2) : Mth.m_144914_((double)shoreWeight, (double)x2, (double)1.0, (double)y2, (double)1.0);
            double adjustedHeight = Math.max(adjustedShoreWeight / shoreWeight * shoreHeight + (adjustedNormalWeight = 1.0 - adjustedShoreWeight) / (normalWeight = 1.0 - shoreWeight) * normalHeight, (double)this.seaLevel);
            if (adjustedHeight < height) {
                height = adjustedHeight;
            }
            biomeAt = shoreBiomeAt;
        }
        assert (biomeAt != null);
        this.computeInitialRiverWeights(biomeWeights);
        double initialCaveWeight = this.adjustWeightsForRiverCaves();
        RiverInfo info = this.sampleRiverInfo(useCache);
        height = this.adjustHeightForRiverContributions(height, info, initialCaveWeight);
        if (useCache) {
            this.updateLocalCaches(biomeWeights, biomeAt, info, height);
        }
        return height;
    }

    protected void setupColumn(int x, int z) {
        this.blockX = x;
        this.blockZ = z;
        this.localX = x & 0xF;
        this.localZ = z & 0xF;
    }

    private void computeInitialRiverWeights(Object2DoubleMap<BiomeExtension> biomeWeights) {
        Arrays.fill(this.riverBlendWeights, 0.0);
        for (Object2DoubleMap.Entry entry : biomeWeights.object2DoubleEntrySet()) {
            int n = ((BiomeExtension)entry.getKey()).riverBlendType().ordinal();
            this.riverBlendWeights[n] = this.riverBlendWeights[n] + entry.getDoubleValue();
        }
    }

    private double adjustWeightsForRiverCaves() {
        double initialCaveWeight = this.riverBlendWeights[RIVER_TYPE_CAVE];
        if (initialCaveWeight > 0.0) {
            double adjustedCaveWeight = initialCaveWeight < 0.25 ? Mth.m_144914_((double)initialCaveWeight, (double)0.0, (double)0.25, (double)0.0, (double)0.1) : 1.0 - this.riverBlendWeights[RIVER_TYPE_NONE];
            for (RiverBlendType type : RiverBlendType.ALL) {
                double weight = this.riverBlendWeights[type.ordinal()];
                this.riverBlendWeights[type.ordinal()] = weight * (1.0 - adjustedCaveWeight) / (1.0 - initialCaveWeight);
            }
            this.riverBlendWeights[ChunkHeightFiller.RIVER_TYPE_CAVE] = adjustedCaveWeight;
        }
        return initialCaveWeight;
    }

    private double adjustHeightForRiverContributions(double height, @Nullable RiverInfo info, double initialCaveWeight) {
        if (info != null) {
            double riverBlendHeight = 0.0;
            for (RiverBlendType type : RiverBlendType.ALL) {
                double weight = this.riverBlendWeights[type.ordinal()];
                RiverNoiseSampler sampler = this.riverNoiseSamplers.get((Object)type);
                if (type == RiverBlendType.NONE) {
                    riverBlendHeight += weight * height;
                    continue;
                }
                if (!(weight > 0.0)) continue;
                double riverHeight = sampler.setColumnAndSampleHeight(info, this.blockX, this.blockZ, height, initialCaveWeight);
                riverBlendHeight += weight * riverHeight;
            }
            return riverBlendHeight;
        }
        Arrays.fill(this.riverBlendWeights, 0.0);
        this.riverBlendWeights[ChunkHeightFiller.RIVER_TYPE_NONE] = 1.0;
        return height;
    }

    protected void updateLocalCaches(Object2DoubleMap<BiomeExtension> biomeWeights, BiomeExtension biomeAt, @Nullable RiverInfo info, double height) {
    }

    @Nullable
    protected RiverInfo sampleRiverInfo(boolean useCache) {
        return this.sampleRiverEdge(this.biomeSource.getPartition(this.blockX, this.blockZ));
    }

    @Nullable
    protected final RiverInfo sampleRiverEdge(RegionPartition.Point point) {
        float limitDistInGridSq = 0.15258789f;
        double minDist = 0.152587890625;
        double minDistAdjusted = 3.4028234663852886E38;
        RiverEdge minEdge = null;
        double exactGridX = Units.blockToGridExact(this.blockX);
        double exactGridZ = Units.blockToGridExact(this.blockZ);
        for (RiverEdge edge : point.rivers()) {
            double distAdjusted;
            double dist;
            MidpointFractal fractal = edge.fractal();
            if (!fractal.maybeIntersect(exactGridX, exactGridZ, minDist) || !((dist = fractal.intersectDistance(exactGridX, exactGridZ)) < 0.152587890625) || !((distAdjusted = dist / (double)edge.widthSq()) < minDistAdjusted)) continue;
            minDist = dist;
            minDistAdjusted = distAdjusted;
            minEdge = edge;
        }
        if (minEdge != null) {
            double realWidth = minEdge.widthSq(exactGridX, exactGridZ);
            Flow flow = minEdge.fractal().calculateFlow(exactGridX, exactGridZ);
            return new RiverInfo(minEdge, flow, minDist *= 16384.0, realWidth);
        }
        return null;
    }
}

