/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.rotation;

import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public interface Rotation {
    public static Tickable of(final Direction direction, final float initialSpeed) {
        return new Tickable(){
            float angle = 0.0f;
            float speed = initialSpeed;

            @Override
            public void tick() {
                this.angle += this.speed;
                if (this.angle > (float)Math.PI * 2) {
                    this.angle -= (float)Math.PI * 2;
                }
                if (this.angle < 0.0f) {
                    this.angle += (float)Math.PI * 2;
                }
            }

            @Override
            public void set(float angle, float speed) {
                this.angle = angle;
                this.speed = speed;
            }

            @Override
            public float angle(float partialTick) {
                return this.angle + this.speed * partialTick;
            }

            @Override
            public float speed() {
                return this.speed;
            }

            @Override
            public Direction direction() {
                return direction;
            }
        };
    }

    public static Rotation of(final Rotation source, final Direction direction) {
        return new Rotation(){

            @Override
            public float angle(float partialTick) {
                return source.angle(partialTick);
            }

            @Override
            public float speed() {
                return source.speed();
            }

            @Override
            public Direction direction() {
                return direction;
            }
        };
    }

    public static Tickable ofFake() {
        return new Tickable(){

            @Override
            public void tick() {
            }

            @Override
            public void set(float angle, float speed) {
            }

            @Override
            public float angle(float partialTick) {
                return (float)(((double)(Calendars.CLIENT.getTicks() % 480000L) + (double)partialTick) * (double)this.speed() % 6.2831854820251465);
            }

            @Override
            public float speed() {
                return 0.03926991f;
            }

            @Override
            public Direction direction() {
                return Direction.UP;
            }
        };
    }

    public static float angle(@Nullable Rotation rotation, float partialTick) {
        return rotation == null ? 0.0f : Rotation.clampToTwoPi((float)rotation.direction().m_122421_().m_122540_() * rotation.angle(partialTick));
    }

    private static float clampToTwoPi(float angle) {
        return angle < 0.0f ? (float)Math.PI * 2 + angle : angle;
    }

    public float angle(float var1);

    default public float angle() {
        return this.angle(0.0f);
    }

    public float speed();

    default public float positiveSpeed() {
        return Mth.m_14154_((float)this.speed());
    }

    public Direction direction();

    default public Direction positiveDirection() {
        return this.speed() < 0.0f ? this.direction().m_122424_() : this.direction();
    }

    public static interface Tickable
    extends Rotation {
        public void tick();

        public void set(float var1, float var2);

        default public void setSpeed(float speed) {
            this.set(this.angle(), speed);
        }

        default public void reset() {
            this.set(0.0f, 0.0f);
        }

        default public void loadFromTag(CompoundTag tag) {
            this.set(tag.m_128457_("rtAngle"), tag.m_128457_("rtSpeed"));
        }

        default public void saveToTag(CompoundTag tag) {
            tag.m_128350_("rtAngle", this.angle());
            tag.m_128350_("rtSpeed", this.speed());
        }
    }
}

