/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.loot.AlwaysTrueCondition;
import net.dries007.tfc.util.loot.AnimalYieldProvider;
import net.dries007.tfc.util.loot.CopyFluidFunction;
import net.dries007.tfc.util.loot.CropYieldProvider;
import net.dries007.tfc.util.loot.IsBurntOutCondition;
import net.dries007.tfc.util.loot.IsIsolatedCondition;
import net.dries007.tfc.util.loot.IsMaleCondition;
import net.dries007.tfc.util.loot.MinMaxProvider;
import net.dries007.tfc.util.loot.NotPredatedCondition;
import net.dries007.tfc.util.loot.RottenFunction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class TFCLoot {
    public static final DeferredRegister<LootItemConditionType> CONDITIONS = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"tfc");
    public static final DeferredRegister<LootNumberProviderType> NUMBER_PROVIDERS = DeferredRegister.create((ResourceKey)Registries.f_256829_, (String)"tfc");
    public static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTIONS = DeferredRegister.create((ResourceKey)Registries.f_257015_, (String)"tfc");
    public static final LootContextParam<Boolean> ISOLATED = new LootContextParam(Helpers.identifier("isolated"));
    public static final LootContextParam<Boolean> BURNT_OUT = new LootContextParam(Helpers.identifier("burnt_out"));
    public static final RegistryObject<LootItemConditionType> IS_ISOLATED = TFCLoot.lootCondition("is_isolated", new InstanceSerializer<IsIsolatedCondition>(IsIsolatedCondition.INSTANCE));
    public static final RegistryObject<LootItemConditionType> IS_BURNT_OUT = TFCLoot.lootCondition("is_burnt_out", new InstanceSerializer<IsBurntOutCondition>(IsBurntOutCondition.INSTANCE));
    public static final RegistryObject<LootItemConditionType> IS_MALE = TFCLoot.lootCondition("is_male", new InstanceSerializer<IsMaleCondition>(IsMaleCondition.INSTANCE));
    public static final RegistryObject<LootItemConditionType> ALWAYS_TRUE = TFCLoot.lootCondition("always_true", new InstanceSerializer<AlwaysTrueCondition>(AlwaysTrueCondition.INSTANCE));
    public static final RegistryObject<LootItemConditionType> NOT_PREDATED = TFCLoot.lootCondition("not_predated", new InstanceSerializer<NotPredatedCondition>(NotPredatedCondition.INSTANCE));
    public static final RegistryObject<LootNumberProviderType> CROP_YIELD = TFCLoot.numberProvider("crop_yield_uniform", new MinMaxProvider.Serializer(CropYieldProvider::new));
    public static final RegistryObject<LootNumberProviderType> ANIMAL_YIELD = TFCLoot.numberProvider("animal_yield", new MinMaxProvider.Serializer(AnimalYieldProvider::new));
    public static final RegistryObject<LootItemFunctionType> COPY_FLUID = TFCLoot.lootFunction("copy_fluid", (Serializer<? extends LootItemFunction>)new CopyFluidFunction.Serializer());
    public static final RegistryObject<LootItemFunctionType> ROTTEN = TFCLoot.lootFunction("rotten", (Serializer<? extends LootItemFunction>)new RottenFunction.Serializer());

    private static RegistryObject<LootItemFunctionType> lootFunction(String id, Serializer<? extends LootItemFunction> serializer) {
        return LOOT_FUNCTIONS.register(id, () -> new LootItemFunctionType(serializer));
    }

    private static RegistryObject<LootItemConditionType> lootCondition(String id, Serializer<? extends LootItemCondition> serializer) {
        return CONDITIONS.register(id, () -> new LootItemConditionType(serializer));
    }

    private static RegistryObject<LootNumberProviderType> numberProvider(String id, Serializer<? extends NumberProvider> serializer) {
        return NUMBER_PROVIDERS.register(id, () -> new LootNumberProviderType(serializer));
    }

    public record InstanceSerializer<T extends LootItemCondition>(T instance) implements Serializer<T>
    {
        public void serialize(JsonObject json, T value, JsonSerializationContext context) {
        }

        public T deserialize(JsonObject json, JsonDeserializationContext context) {
            return this.instance;
        }
    }
}

