/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.collections;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.dries007.tfc.util.collections.IWeighted;

public class Weighted<E>
implements IWeighted<E> {
    private final NavigableMap<Double, E> backingMap = new TreeMap<Double, E>();
    private double totalWeight = 0.0;
    private List<Pair<E, Double>> weightedValues;

    public Weighted(List<Pair<E, Double>> parallelWeightedList) {
        parallelWeightedList.forEach(pair -> this.add((Double)pair.getSecond(), pair.getFirst()));
    }

    @Override
    public void add(double weight, E result) {
        if (weight > 0.0) {
            this.totalWeight += weight;
            this.backingMap.put(this.totalWeight, result);
        }
    }

    @Override
    public E get(double random) {
        double value = random * this.totalWeight;
        return this.backingMap.higherEntry(value).getValue();
    }

    @Override
    public Collection<E> values() {
        return this.backingMap.values();
    }

    @Override
    public List<Pair<E, Double>> weightedValues() {
        if (this.weightedValues == null) {
            this.weightedValues = this.backingMap.entrySet().stream().map(e -> Pair.of(e.getValue(), (Object)((Double)e.getKey()))).collect(Collectors.toList());
        }
        return this.weightedValues;
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingMap.values().iterator();
    }
}

