/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.IcePileBlock;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.KrummholzBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.climate.ClimateModelType;
import net.dries007.tfc.util.climate.ClimateModels;
import net.dries007.tfc.util.climate.WorldGenClimateModel;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class OverworldClimateModel
implements WorldGenClimateModel {
    public static final float SNOW_FREEZE_TEMPERATURE = -2.0f;
    public static final float SNOW_MELT_TEMPERATURE = 2.0f;
    public static final float ICE_FREEZE_TEMPERATURE = -4.0f;
    public static final float ICE_MELT_TEMPERATURE = 2.0f;
    public static final float ICICLE_MIN_FREEZE_TEMPERATURE = -10.0f;
    public static final float ICICLE_MAX_FREEZE_TEMPERATURE = -2.0f;
    public static final float ICICLE_DRIP_TEMPERATURE = 0.0f;
    public static final float ICICLE_MELT_TEMPERATURE = 4.0f;
    public static final float LAVA_LEVEL_TEMPERATURE = 15.0f;
    public static final float SEA_LEVEL = 63.0f;
    public static final float DEPTH_LEVEL = -64.0f;
    public static final int FOGGY_DAY_RARITY = 10;
    public static final float FOGGY_RAINFALL_MINIMUM = 150.0f;
    public static final float FOGGY_RAINFALL_PEAK = 300.0f;
    private long climateSeed = 0L;
    private float temperatureScale = 20000.0f;
    private Noise2D snowPatchNoise = (x, z) -> 0.0;
    private Noise2D icePatchNoise = (x, z) -> 0.0;

    public static float getAdjustedAverageTempByElevation(BlockPos pos, ChunkData chunkData) {
        return OverworldClimateModel.getAdjustedAverageTempByElevation(pos.m_123342_(), chunkData.getAverageTemp(pos));
    }

    public static float getAdjustedAverageTempByElevation(int y, float averageTemperature) {
        if ((float)y > 63.0f) {
            float elevationTemperature = Mth.m_14036_((float)(((float)y - 63.0f) * 0.16225f), (float)0.0f, (float)17.822f);
            return averageTemperature - elevationTemperature;
        }
        return averageTemperature;
    }

    @Override
    public ClimateModelType type() {
        return ClimateModels.OVERWORLD.get();
    }

    @Nullable
    public static OverworldClimateModel getIfPresent(Object maybeLevel) {
        ClimateModel model;
        Level unsafeLevel = Helpers.getUnsafeLevel(maybeLevel);
        if (unsafeLevel != null && (model = Climate.model(unsafeLevel)) instanceof OverworldClimateModel) {
            OverworldClimateModel overworldClimateModel = (OverworldClimateModel)model;
            return overworldClimateModel;
        }
        return null;
    }

    public float getAverageMonthlyTemperature(int z, int y, float averageTemperature, float monthFactor) {
        float monthlyTemperature = this.calculateMonthlyTemperature(z, monthFactor);
        return this.adjustTemperatureByElevation(y, averageTemperature, monthlyTemperature, 0.0f);
    }

    @Override
    public float getTemperature(@Nullable LevelReader level, BlockPos pos, ChunkData data, long calendarTicks, int daysInMonth) {
        Month currentMonth = ICalendar.getMonthOfYear(calendarTicks, daysInMonth);
        float delta = ICalendar.getFractionOfMonth(calendarTicks, daysInMonth);
        float monthFactor = Mth.m_14179_((float)delta, (float)currentMonth.getTemperatureModifier(), (float)currentMonth.next().getTemperatureModifier());
        float monthTemperature = this.calculateMonthlyTemperature(pos.m_123343_(), monthFactor);
        float dailyTemperature = this.calculateDailyTemperature(calendarTicks);
        return this.adjustTemperatureByElevation(pos.m_123342_(), data.getAverageTemp(pos), monthTemperature, dailyTemperature);
    }

    @Override
    public float getAverageTemperature(LevelReader level, BlockPos pos) {
        return ChunkData.get(level, pos).getAverageTemp(pos);
    }

    @Override
    public float getRainfall(LevelReader level, BlockPos pos) {
        ChunkData data = ChunkData.get(level, pos);
        return data.getRainfall(pos);
    }

    @Override
    public float getFogginess(LevelReader level, BlockPos pos, long calendarTime) {
        long day = ICalendar.getTotalDays(calendarTime + 2000L);
        Random random = this.seededRandom(day, 129341623413L);
        if (random.nextInt(10) != 0) {
            return 0.0f;
        }
        float fogModifier = random.nextFloat();
        long dayTime = Calendars.get(level).getCalendarDayTime();
        float scaledTime = dayTime > 22000L ? Mth.m_184637_((float)dayTime, (float)22000.0f, (float)24000.0f, (float)0.0f, (float)1.0f) : (dayTime >= 0L && dayTime < 4000L ? 1.0f : (dayTime >= 4000L && dayTime < 6000L ? 1.0f - Mth.m_184637_((float)dayTime, (float)4000.0f, (float)6000.0f, (float)0.0f, (float)1.0f) : 0.0f));
        float rainfall = this.getRainfall(level, pos);
        float rainfallModifier = Mth.m_184631_((float)rainfall, (float)150.0f, (float)300.0f, (float)0.0f, (float)1.0f);
        float skylightModifier = Mth.m_184631_((float)level.m_45517_(LightLayer.SKY, pos), (float)0.0f, (float)10.0f, (float)0.0f, (float)1.0f);
        return Helpers.easeInOutCubic(scaledTime) * fogModifier * rainfallModifier * skylightModifier;
    }

    @Override
    public float getWaterFogginess(LevelReader level, BlockPos pos, long calendarTime) {
        if (Helpers.isFluid(level.m_6425_(pos), (Fluid)Fluids.f_76193_)) {
            return Mth.m_184631_((float)level.m_45524_(pos, 0), (float)0.0f, (float)15.0f, (float)0.6f, (float)1.0f);
        }
        return 1.0f;
    }

    @Override
    public Vec2 getWindVector(Level level, BlockPos pos, long calendarTime) {
        int y = pos.m_123342_();
        if ((float)y < 57.0f) {
            return Vec2.f_82462_;
        }
        Random random = this.seededRandom(ICalendar.getTotalDays(calendarTime), 129341623413L);
        Holder biome = level.m_204166_(pos);
        if (biome.m_203656_(TFCTags.Biomes.HAS_PREDICTABLE_WINDS)) {
            boolean isDay = level.m_46468_() % 24000L < 12000L;
            int windScale = (Integer)TFCConfig.SERVER.oceanWindScale.get();
            boolean oddBand = pos.m_123343_() < 0 ? pos.m_123343_() % (windScale * 2) < windScale : pos.m_123343_() % (windScale * 2) > windScale;
            float intensity = random.nextFloat() * 0.3f + 0.3f + 0.4f * level.m_46722_(0.0f);
            float angle = isDay && oddBand ? 0.7853982f : (isDay ? 5.4977875f : (oddBand ? 3.926991f : 2.3561945f));
            return new Vec2(Mth.m_14089_((float)(angle += random.nextFloat() * 0.2f - 0.1f)), Mth.m_14031_((float)angle)).m_165903_(intensity);
        }
        float preventFrequentWindyDays = random.nextFloat() < 0.1f ? 1.0f : random.nextFloat();
        float intensity = Math.min(0.5f * random.nextFloat() * preventFrequentWindyDays + 0.4f * Mth.m_184631_((float)y, (float)63.0f, (float)128.0f, (float)0.0f, (float)1.0f) + 0.6f * level.m_46722_(0.0f), 1.0f);
        float angle = random.nextFloat() * ((float)Math.PI * 2);
        return new Vec2(Mth.m_14089_((float)angle), Mth.m_14031_((float)angle)).m_165903_(intensity);
    }

    @Override
    public void onChunkLoad(WorldGenLevel level, ChunkAccess chunk, ChunkData chunkData) {
        ChunkPos chunkPos = chunk.m_7697_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockState snowState = Blocks.f_50125_.m_49966_();
        for (int x = chunkPos.m_45604_(); x <= chunkPos.m_45608_(); ++x) {
            for (int z = chunkPos.m_45605_(); z <= chunkPos.m_45609_(); ++z) {
                float temperatureModifier;
                float waterDepthModifier;
                mutablePos.m_122178_(x, level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z), z);
                float noise = (float)this.snowPatchNoise.noise(x, z);
                float temperature = this.getTemperature(null, (BlockPos)mutablePos, chunkData, Calendars.SERVER.getCalendarTicks(), Calendars.SERVER.getCalendarDaysInMonth());
                float snowTemperatureModifier = Mth.m_184631_((float)temperature, (float)-10.0f, (float)2.0f, (float)-1.0f, (float)1.0f);
                BlockState stateAt = level.m_8055_((BlockPos)mutablePos);
                if (snowTemperatureModifier + noise < 0.0f && level.m_45517_(LightLayer.BLOCK, (BlockPos)mutablePos) <= 11) {
                    if (stateAt.m_60795_() && snowState.m_60710_((LevelReader)level, (BlockPos)mutablePos)) {
                        level.m_7731_((BlockPos)mutablePos, Blocks.f_50125_.m_49966_(), 2);
                        mutablePos.m_122173_(Direction.DOWN);
                        level.m_7731_((BlockPos)mutablePos, Helpers.setProperty(level.m_8055_((BlockPos)mutablePos), SnowyDirtBlock.f_56637_, true), 2);
                        mutablePos.m_122173_(Direction.UP);
                    } else if (SnowPileBlock.canPlaceSnowPile((LevelAccessor)level, (BlockPos)mutablePos, stateAt)) {
                        SnowPileBlock.placeSnowPile((LevelAccessor)level, (BlockPos)mutablePos, stateAt, false);
                        level.m_7731_((BlockPos)mutablePos, Helpers.setProperty(level.m_8055_((BlockPos)mutablePos), SnowyDirtBlock.f_56637_, true), 2);
                    } else if (stateAt.m_60734_() instanceof KrummholzBlock) {
                        KrummholzBlock.updateFreezingInColumn((LevelAccessor)level, (BlockPos)mutablePos, true);
                    }
                }
                mutablePos.m_122173_(Direction.DOWN);
                stateAt = level.m_8055_((BlockPos)mutablePos);
                if (!EnvironmentHelpers.isWater(stateAt) && !EnvironmentHelpers.isIce(stateAt)) continue;
                float threshold = (float)this.icePatchNoise.noise((float)x * 0.2f, (float)z * 0.2f) + Mth.m_14036_((float)(temperature * 0.1f), (float)-0.2f, (float)0.2f);
                if (Helpers.isBlock(stateAt, Blocks.f_50126_) || Helpers.isBlock(stateAt, Blocks.f_49990_)) {
                    int waterDepth = mutablePos.m_123342_() - level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
                    waterDepthModifier = Mth.m_184631_((float)waterDepth, (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f);
                    temperatureModifier = Mth.m_184631_((float)temperature, (float)-4.0f, (float)2.0f, (float)-0.4f, (float)1.0f);
                } else {
                    float maxAnnualTemperature = this.getAverageMonthlyTemperature(z, 63, chunkData.getAverageTemp(x, z), 1.0f);
                    waterDepthModifier = 0.0f;
                    temperatureModifier = Mth.m_184631_((float)maxAnnualTemperature, (float)-4.0f, (float)8.0f, (float)-0.8f, (float)1.0f);
                }
                if (!(waterDepthModifier + temperatureModifier < threshold) || !(temperatureModifier < 1.0f)) continue;
                if (Helpers.isBlock(stateAt, (Block)TFCBlocks.SALT_WATER.get())) {
                    level.m_7731_((BlockPos)mutablePos, ((Block)TFCBlocks.SEA_ICE.get()).m_49966_(), 2);
                    continue;
                }
                IcePileBlock.placeIcePileOrIce((LevelAccessor)level, (BlockPos)mutablePos, stateAt, true);
            }
        }
    }

    @Override
    public void onWorldLoad(ServerLevel level) {
        ChunkGeneratorExtension extension = (ChunkGeneratorExtension)level.m_7726_().m_8481_();
        this.temperatureScale = extension.settings().temperatureScale();
        this.climateSeed = LinearCongruentialGenerator.m_13972_((long)level.m_7328_(), (long)719283741234L);
        this.updateNoise();
    }

    @Override
    public void onSyncToClient(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.temperatureScale);
        buffer.writeLong(this.climateSeed);
    }

    @Override
    public void onReceiveOnClient(FriendlyByteBuf buffer) {
        this.temperatureScale = buffer.readFloat();
        this.climateSeed = buffer.readLong();
    }

    protected void updateNoise() {
        this.snowPatchNoise = new OpenSimplex2D(this.climateSeed + 72397489123L).octaves(2).spread(0.3f).scaled(-1.0, 1.0);
        this.icePatchNoise = new OpenSimplex2D(this.climateSeed + 192639412341L).octaves(3).spread(0.6f);
    }

    protected float adjustTemperatureByElevation(int y, float averageTemperature, float monthTemperature, float dailyTemperature) {
        if ((float)y > 63.0f) {
            float elevationTemperature = Mth.m_14036_((float)(((float)y - 63.0f) * 0.16225f), (float)0.0f, (float)17.822f);
            return averageTemperature + monthTemperature - elevationTemperature + dailyTemperature;
        }
        if (y > 0) {
            float monthInfluence = Helpers.inverseLerp(y, 0.0f, 63.0f);
            float dailyInfluence = Mth.m_14036_((float)(monthInfluence * 3.0f - 2.0f), (float)0.0f, (float)1.0f);
            return averageTemperature + Mth.m_14179_((float)monthInfluence, (float)0.0f, (float)monthTemperature) + Mth.m_14179_((float)dailyInfluence, (float)0.0f, (float)dailyTemperature);
        }
        float depthInfluence = Helpers.inverseLerp(y, -64.0f, 0.0f);
        return Mth.m_14179_((float)depthInfluence, (float)15.0f, (float)averageTemperature);
    }

    protected float calculateMonthlyTemperature(int z, float monthTemperatureModifier) {
        return monthTemperatureModifier * (this.temperatureScale == 0.0f ? 0.0f : Helpers.triangle(-3.0f, 15.0f, 1.0f / (2.0f * this.temperatureScale), z));
    }

    protected float calculateDailyTemperature(long calendarTime) {
        int hourOfDay = ICalendar.getHourOfDay(calendarTime);
        if (hourOfDay > 12) {
            hourOfDay = 24 - hourOfDay;
        }
        float hourModifier = (float)hourOfDay / 6.0f - 1.0f;
        long day = ICalendar.getTotalDays(calendarTime);
        Random random = this.seededRandom(day, 1986239412341L);
        return (random.nextFloat() - random.nextFloat() + 0.3f * hourModifier) * 3.0f;
    }

    protected Random seededRandom(long day, long salt) {
        long seed = LinearCongruentialGenerator.m_13972_((long)this.climateSeed, (long)day);
        seed = LinearCongruentialGenerator.m_13972_((long)seed, (long)salt);
        return new Random(seed);
    }
}

