/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Season;

public enum Month {
    JANUARY(-1.0f, Season.WINTER),
    FEBRUARY(-0.866f, Season.WINTER),
    MARCH(-0.5f, Season.SPRING),
    APRIL(0.0f, Season.SPRING),
    MAY(0.5f, Season.SPRING),
    JUNE(0.866f, Season.SUMMER),
    JULY(1.0f, Season.SUMMER),
    AUGUST(0.866f, Season.SUMMER),
    SEPTEMBER(0.5f, Season.FALL),
    OCTOBER(0.0f, Season.FALL),
    NOVEMBER(-0.5f, Season.FALL),
    DECEMBER(-0.866f, Season.WINTER);

    private static final Month[] VALUES;
    private final float temperatureModifier;
    private final Season season;

    public static Month valueOf(int id) {
        return id >= 0 && id < VALUES.length ? VALUES[id] : JANUARY;
    }

    private Month(float temperatureModifier, Season season) {
        this.temperatureModifier = temperatureModifier;
        this.season = season;
    }

    public float getTemperatureModifier() {
        return this.temperatureModifier;
    }

    public Month next() {
        return this == DECEMBER ? JANUARY : VALUES[this.ordinal() + 1];
    }

    public String getTranslationKey(Style style) {
        return switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case Style.LONG_MONTH -> Helpers.getEnumTranslationKey(this);
            case Style.SEASON -> Helpers.getEnumTranslationKey(this, "season");
        };
    }

    public Season getSeason() {
        return this.season;
    }

    static {
        VALUES = Month.values();
    }

    public static enum Style {
        LONG_MONTH,
        SEASON;

    }
}

