/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Arrays;
import java.util.Locale;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistry;

public final class JsonHelpers
extends GsonHelper {
    @Deprecated
    public static <T> T getRegistryEntry(JsonObject json, String key, IForgeRegistry<T> registry) {
        return JsonHelpers.getRegistryEntry(GsonHelper.m_13906_((JsonObject)json, (String)key), registry);
    }

    @Deprecated
    public static <T> T getRegistryEntry(JsonElement json, IForgeRegistry<T> registry) {
        return JsonHelpers.getRegistryEntry(GsonHelper.m_13805_((JsonElement)json, (String)"entry"), registry);
    }

    @Deprecated
    public static <T> T getRegistryEntry(String key, IForgeRegistry<T> registry) {
        ResourceLocation res = Helpers.resourceLocation(key);
        Object obj = registry.getValue(res);
        if (obj == null || !registry.containsKey(res)) {
            throw new JsonParseException("Unknown " + registry.getRegistryName().m_135815_() + ": " + key);
        }
        return (T)obj;
    }

    public static <T> T getRegistryEntry(JsonObject json, String key, Registry<T> registry) {
        return JsonHelpers.getRegistryEntry(GsonHelper.m_13906_((JsonObject)json, (String)key), registry);
    }

    public static <T> T getRegistryEntry(JsonElement json, Registry<T> registry) {
        return JsonHelpers.getRegistryEntry(GsonHelper.m_13805_((JsonElement)json, (String)"entry"), registry);
    }

    public static <T> T getRegistryEntry(String key, Registry<T> registry) {
        ResourceLocation res = Helpers.resourceLocation(key);
        Object obj = registry.m_7745_(res);
        if (obj == null || !registry.m_7804_(res)) {
            throw new JsonParseException("Unknown " + registry.m_123023_().m_135782_().m_135815_() + ": " + key);
        }
        return (T)obj;
    }

    public static <T> TagKey<T> getTag(JsonObject json, String key, ResourceKey<? extends Registry<T>> registry) {
        return JsonHelpers.getTag(GsonHelper.m_13906_((JsonObject)json, (String)key), registry);
    }

    public static <T> TagKey<T> getTag(String key, ResourceKey<? extends Registry<T>> registry) {
        ResourceLocation res = Helpers.resourceLocation(key);
        return TagKey.m_203882_(registry, (ResourceLocation)res);
    }

    public static <E extends Enum<E>> E getEnum(JsonObject obj, String key, Class<E> enumClass, E defaultValue) {
        if (obj.has(key)) {
            return JsonHelpers.getEnum(obj.get(key), enumClass);
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> E getEnum(JsonElement json, Class<E> enumClass) {
        String enumName = JsonHelpers.m_13805_((JsonElement)json, (String)enumClass.getSimpleName());
        try {
            return Enum.valueOf(enumClass, enumName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("No " + enumClass.getSimpleName() + " named: " + enumName);
        }
    }

    public static CraftingBookCategory getCraftingCategory(JsonObject json) {
        return (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(JsonHelpers.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
    }

    public static <T> DataManager.Reference<T> getReference(JsonObject json, String key, DataManager<T> manager) {
        return manager.getReference(Helpers.resourceLocation(JsonHelpers.m_13906_((JsonObject)json, (String)key)));
    }

    public static ResourceLocation getResourceLocation(JsonObject json, String key) {
        return Helpers.resourceLocation(JsonHelpers.m_13906_((JsonObject)json, (String)key));
    }

    public static ItemStack getItemStack(JsonObject json) {
        return CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
    }

    public static ItemStack getItemStack(JsonObject json, String key) {
        return JsonHelpers.getItemStack(JsonHelpers.m_13930_((JsonObject)json, (String)key));
    }

    public static JsonElement get(JsonObject json, String key) {
        if (!json.has(key)) {
            throw new JsonParseException("Missing required key: " + key);
        }
        return json.get(key);
    }

    public static FluidStack getFluidStack(JsonObject json, String key) {
        return JsonHelpers.getFluidStack(JsonHelpers.m_13930_((JsonObject)json, (String)key));
    }

    public static FluidStack getFluidStack(JsonObject json) {
        int amount = GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)1000);
        Fluid fluid = (Fluid)JsonHelpers.getRegistryEntry(json, "fluid", BuiltInRegistries.f_257020_);
        return new FluidStack(fluid, amount);
    }

    public static BlockState getBlockState(String block) {
        StringReader reader = new StringReader(block);
        try {
            return BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)reader, (boolean)false).f_234748_();
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException(e.getMessage());
        }
    }

    public static DyeColor getDyeColor(JsonObject json, String key) {
        String name = JsonHelpers.m_13906_((JsonObject)json, (String)key);
        DyeColor color = DyeColor.m_41057_((String)name, null);
        if (color == null) {
            throw new JsonParseException("No dye color named '" + name + "', must be one of " + Arrays.toString(DyeColor.values()));
        }
        return color;
    }

    public static <T> T decodeCodecDefaulting(JsonObject json, Codec<T> codec, String key, T defaultValue) {
        if (!json.has(key)) {
            return defaultValue;
        }
        return JsonHelpers.decodeCodec(json, codec, key);
    }

    public static <T> T decodeCodec(JsonObject json, Codec<T> codec, String key) {
        Object result = ((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get(key)).getOrThrow(false, e -> {})).getFirst();
        if (result == null) {
            throw new JsonParseException("Unable to parse fauna json: " + json);
        }
        return (T)result;
    }
}

