/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.stream.Stream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.QuernBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.QuernBlock;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.FluidContainerItem;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.items.TFCMinecartItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.accessor.DispenserBlockAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public final class DispenserBehaviors {
    public static final DispenseItemBehavior DEFAULT = new DefaultDispenseItemBehavior();
    public static final DispenseItemBehavior VANILLA_BUCKET_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BucketItem bucket = (BucketItem)stack.m_41720_();
            BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = source.m_7727_();
            if (bucket.emptyContents(null, (Level)level, pos, null, stack)) {
                bucket.m_142131_(null, (Level)level, stack, pos);
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return DEFAULT.m_6115_(source, stack);
        }
    };
    public static final DispenseItemBehavior TFC_BUCKET_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            ServerLevel level = source.m_7727_();
            BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            Item item = stack.m_41720_();
            if (item instanceof FluidContainerItem) {
                FluidContainerItem item2 = (FluidContainerItem)item;
                MutableObject result = new MutableObject();
                result.setValue((Object)stack);
                FluidHelpers.transferBetweenWorldAndItem(stack, (Level)level, pos, null, (arg_0, arg_1) -> 2.lambda$execute$0((Mutable)result, source, arg_0, arg_1), item2.canPlaceLiquidsInWorld(), item2.canPlaceSourceBlocks(), false);
                return (ItemStack)result.getValue();
            }
            return stack;
        }

        private static /* synthetic */ void lambda$execute$0(Mutable result, BlockSource source, ItemStack newOriginalStack, ItemStack newContainerStack) {
            result.setValue((Object)newOriginalStack);
            if (!newContainerStack.m_41619_() && ((DispenserBlockEntity)source.m_8118_()).m_59237_(newContainerStack) < 0) {
                DEFAULT.m_6115_(source, newContainerStack);
            }
        }
    };
    public static final DispenseItemBehavior CHEST_BEHAVIOR = new OptionalDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource level, ItemStack stack) {
            BlockPos blockpos = level.m_7961_().m_121945_((Direction)level.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            for (AbstractChestedHorse horse2 : level.m_7727_().m_6443_(AbstractChestedHorse.class, new AABB(blockpos), horse -> horse.m_6084_() && !horse.m_30502_())) {
                if (!horse2.m_30614_() || !horse2.m_141942_(499).m_142104_(stack)) continue;
                stack.m_41774_(1);
                this.m_123573_(true);
                return stack;
            }
            return super.m_7498_(level, stack);
        }
    };
    public static DispenseItemBehavior MINECART_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Item item = stack.m_41720_();
            if (item instanceof TFCMinecartItem) {
                double offset;
                RailShape railshape;
                TFCMinecartItem cartItem = (TFCMinecartItem)item;
                Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                ServerLevel level = source.m_7727_();
                double x = source.m_7096_() + (double)direction.m_122429_() * 1.125;
                double y = Math.floor(source.m_7098_()) + (double)direction.m_122430_();
                double z = source.m_7094_() + (double)direction.m_122431_() * 1.125;
                BlockPos offsetPos = source.m_7961_().m_121945_(direction);
                BlockState state = level.m_8055_(offsetPos);
                RailShape railShape = railshape = state.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)state.m_60734_()).getRailDirection(state, (BlockGetter)level, offsetPos, null) : RailShape.NORTH_SOUTH;
                if (Helpers.isBlock(state, (TagKey<Block>)BlockTags.f_13034_)) {
                    offset = railshape.m_61745_() ? 0.6 : 0.1;
                } else {
                    if (!state.m_60795_() || !Helpers.isBlock(level.m_8055_(offsetPos.m_7495_()), (TagKey<Block>)BlockTags.f_13034_)) {
                        return this.defaultBehavior.m_6115_(source, stack);
                    }
                    BlockState offsetState = level.m_8055_(offsetPos.m_7495_());
                    RailShape offsetShape = offsetState.m_60734_() instanceof BaseRailBlock ? (RailShape)offsetState.m_61143_(((BaseRailBlock)offsetState.m_60734_()).m_7978_()) : RailShape.NORTH_SOUTH;
                    offset = direction != Direction.DOWN && offsetShape.m_61745_() ? -0.4 : -0.9;
                }
                cartItem.createMinecartEntity((Level)level, stack, x, y + offset, z);
                return stack;
            }
            return ItemStack.f_41583_;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1000, source.m_7961_(), 0);
        }
    };
    public static final OptionalDispenseItemBehavior TFC_FLINT_AND_STEEL_BEHAVIOR = new OptionalDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            ServerLevel level = source.m_7727_();
            Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos pos = source.m_7961_().m_121945_(facing);
            BlockState state = level.m_8055_(pos);
            if (((Boolean)TFCConfig.SERVER.dispenserEnableLighting.get()).booleanValue() && StartFireEvent.startFire((Level)level, pos, state, facing.m_122424_(), null, stack, StartFireEvent.FireStrength.STRONG)) {
                if (stack.m_220157_(1, level.m_213780_(), null)) {
                    stack.m_41764_(0);
                }
                return stack;
            }
            this.m_123573_(false);
            return stack;
        }
    };
    public static final DispenseItemBehavior HANDSTONE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            QuernBlockEntity quern;
            BlockEntity blockEntity;
            ServerLevel level = source.m_7727_();
            BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            if (Helpers.isItem(stack, TFCTags.Items.HANDSTONE) && level.m_8055_(pos).m_60734_() instanceof QuernBlock && (blockEntity = level.m_7702_(pos)) instanceof QuernBlockEntity && !(quern = (QuernBlockEntity)blockEntity).hasHandstone()) {
                return quern.getCapability(Capabilities.ITEM).map(inv -> inv.insertItem(0, stack, false)).orElse(stack);
            }
            return stack;
        }
    };

    public static void registerDispenserBehaviors() {
        Stream.of(TFCItems.BLUE_STEEL_BUCKET, TFCItems.RED_STEEL_BUCKET, TFCItems.JUG, TFCItems.WOODEN_BUCKET, TFCItems.SILICA_GLASS_BOTTLE, TFCItems.HEMATITIC_GLASS_BOTTLE, TFCItems.OLIVINE_GLASS_BOTTLE, TFCItems.VOLCANIC_GLASS_BOTTLE).forEach(reg -> DispenserBlock.m_52672_((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)TFC_BUCKET_BEHAVIOR));
        Stream.of(TFCItems.COD_BUCKET, TFCItems.JELLYFISH_BUCKET, TFCItems.TROPICAL_FISH_BUCKET, TFCItems.PUFFERFISH_BUCKET).forEach(reg -> DispenserBlock.m_52672_((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)VANILLA_BUCKET_BEHAVIOR));
        TFCItems.FLUID_BUCKETS.values().forEach(reg -> DispenserBlock.m_52672_((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)VANILLA_BUCKET_BEHAVIOR));
        TFCItems.FRESHWATER_FISH_BUCKETS.values().forEach(reg -> DispenserBlock.m_52672_((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)VANILLA_BUCKET_BEHAVIOR));
        TFCBlocks.WOODS.values().stream().map(map -> (Block)((RegistryObject)map.get((Object)Wood.BlockType.CHEST)).get()).forEach(chest -> DispenserBlock.m_52672_((ItemLike)chest, (DispenseItemBehavior)CHEST_BEHAVIOR));
        TFCItems.CHEST_MINECARTS.values().forEach(reg -> DispenserBlock.m_52672_((ItemLike)((ItemLike)reg.get()), (DispenseItemBehavior)MINECART_BEHAVIOR));
        DispenserBlock.m_52672_((ItemLike)Items.f_42521_, (DispenseItemBehavior)new DefaultDispenseItemBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_42409_, (DispenseItemBehavior)new MultipleItemBehavior(TFC_FLINT_AND_STEEL_BEHAVIOR, DispenserBlockAccessor.accessor$getDispenserRegistry().get(Items.f_42409_)));
        DispenserBlock.m_52672_((ItemLike)((ItemLike)TFCItems.HANDSTONE.get()), (DispenseItemBehavior)HANDSTONE_BEHAVIOR);
    }

    public static class MultipleItemBehavior
    implements DispenseItemBehavior {
        private final OptionalDispenseItemBehavior primary;
        private final DispenseItemBehavior defaultBehavior;

        public MultipleItemBehavior(OptionalDispenseItemBehavior first, DispenseItemBehavior second) {
            this.primary = first;
            this.defaultBehavior = second;
        }

        public ItemStack m_6115_(BlockSource source, ItemStack stack) {
            ItemStack result = this.primary.m_6115_(source, stack);
            if (this.primary.m_123570_()) {
                return result;
            }
            return this.defaultBehavior.m_6115_(source, stack);
        }
    }
}

