/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin.client;

import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={FogRenderer.class})
public abstract class FogRendererMixin {
    @Redirect(method={"setupColor"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getWaterFogColor()I"))
    private static int setupColorRedirectGetWaterFogColor(Biome biome, Camera camera, float partialTicks, ClientLevel level) {
        return TFCColors.getWaterFogColor((CommonLevelAccessor)level, biome, camera.m_90588_());
    }

    @Redirect(method={"*(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/world/level/biome/BiomeManager;FIII)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getFogColor()I"))
    @Dynamic(value="Lambda method in setupColor")
    private static int setupColorRedirectGetFogColor(Biome biome, ClientLevel level, BiomeManager biomeManager, float brightness, int quartX, int quartY, int quartZ) {
        return TFCColors.getFogColor((CommonLevelAccessor)level, biome, Helpers.quartToBlock(quartX, quartY, quartZ));
    }
}

