/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.NetworkRecipeParityCheck;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.world.item.crafting.Recipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientboundUpdateRecipesPacket.class})
public abstract class ClientboundUpdateRecipesPacketMixin {
    @Inject(method={"fromNetwork"}, at={@At(value="HEAD")}, cancellable=true)
    private static void beforeFromNetwork(FriendlyByteBuf buffer, CallbackInfoReturnable<Recipe<?>> cir) {
        if (TFCConfig.COMMON.enableNetworkDebugging()) {
            cir.setReturnValue(NetworkRecipeParityCheck.decodeRecipe(buffer));
        }
    }

    @Inject(method={"toNetwork"}, at={@At(value="HEAD")})
    private static <T extends Recipe<?>> void beforeToNetwork(FriendlyByteBuf buffer, T recipe, CallbackInfo ci) {
        if (TFCConfig.COMMON.enableNetworkDebugging()) {
            NetworkRecipeParityCheck.encodeRecipePrefix(buffer, recipe);
        }
    }
}

