/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.config;

import java.util.function.Function;
import net.dries007.tfc.config.ClientConfig;
import net.dries007.tfc.config.CommonConfig;
import net.dries007.tfc.config.ConfigBuilder;
import net.dries007.tfc.config.ServerConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class TFCConfig {
    public static final CommonConfig COMMON = (CommonConfig)TFCConfig.register(ModConfig.Type.COMMON, CommonConfig::new, "common").getKey();
    public static final ClientConfig CLIENT = (ClientConfig)TFCConfig.register(ModConfig.Type.CLIENT, ClientConfig::new, "client").getKey();
    public static final ServerConfig SERVER;
    private static final ForgeConfigSpec SERVER_SPEC;

    public static void init() {
    }

    public static boolean isServerConfigLoaded() {
        return SERVER_SPEC.isLoaded();
    }

    private static <C> Pair<C, ForgeConfigSpec> register(ModConfig.Type type, Function<ConfigBuilder, C> factory, String prefix) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> factory.apply(new ConfigBuilder((ForgeConfigSpec.Builder)builder, prefix)));
        if (!Helpers.BOOTSTRAP_ENVIRONMENT) {
            ModLoadingContext.get().registerConfig(type, (IConfigSpec)specPair.getRight());
        }
        return specPair;
    }

    static {
        Pair<ServerConfig, ForgeConfigSpec> pair = TFCConfig.register(ModConfig.Type.SERVER, ServerConfig::new, "server");
        SERVER = (ServerConfig)pair.getKey();
        SERVER_SPEC = (ForgeConfigSpec)pair.getRight();
    }
}

