/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.recipes.ingredients.DelegateIngredient;
import net.dries007.tfc.common.recipes.ingredients.HasTraitIngredient;
import net.dries007.tfc.common.recipes.ingredients.LacksTraitIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public abstract class TraitIngredient
extends DelegateIngredient {
    protected final FoodTrait trait;

    public TraitIngredient(@Nullable Ingredient delegate, FoodTrait trait) {
        super(delegate);
        this.trait = trait;
    }

    public FoodTrait getTrait() {
        return this.trait;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("trait", FoodTrait.getId(this.trait).toString());
        return json;
    }

    public static class TraitSerializer<T extends TraitIngredient>
    implements IIngredientSerializer<T> {
        public static final TraitSerializer<HasTraitIngredient> HAS_TRAIT = new TraitSerializer<HasTraitIngredient>(HasTraitIngredient::new);
        public static final TraitSerializer<LacksTraitIngredient> LACKS_TRAIT = new TraitSerializer<LacksTraitIngredient>(LacksTraitIngredient::new);
        private final BiFunction<Ingredient, FoodTrait, T> factory;

        public TraitSerializer(BiFunction<Ingredient, FoodTrait, T> factory) {
            this.factory = factory;
        }

        public T parse(JsonObject json) {
            Ingredient internal = json.has("ingredient") ? Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingredient")) : null;
            FoodTrait trait = FoodTrait.getTraitOrThrow(JsonHelpers.getResourceLocation(json, "trait"));
            return (T)((Object)((TraitIngredient)((Object)this.factory.apply(internal, trait))));
        }

        public T parse(FriendlyByteBuf buffer) {
            Ingredient internal = Helpers.decodeNullable(buffer, Ingredient::m_43940_);
            FoodTrait trait = FoodTrait.getTraitOrThrow(buffer.m_130281_());
            return (T)((Object)((TraitIngredient)((Object)this.factory.apply(internal, trait))));
        }

        public void write(FriendlyByteBuf buffer, T ingredient) {
            Helpers.encodeNullable(((TraitIngredient)((Object)ingredient)).delegate, buffer, Ingredient::m_43923_);
            buffer.m_130085_(FoodTrait.getId(((TraitIngredient)((Object)ingredient)).getTrait()));
        }
    }
}

