/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.ingredients.DelegateIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class NotIngredient
extends DelegateIngredient {
    private static final NotIngredient ALWAYS_TRUE = new NotIngredient(null);

    public static NotIngredient of(Ingredient ingredient) {
        return new NotIngredient(ingredient);
    }

    public static NotIngredient alwaysTrue() {
        return ALWAYS_TRUE;
    }

    protected NotIngredient(@Nullable Ingredient delegate) {
        super(delegate);
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        return !super.test(stack);
    }

    @Override
    @Nullable
    protected ItemStack testDefaultItem(ItemStack stack) {
        return this.test(stack) ? stack : null;
    }

    @Override
    public IIngredientSerializer<? extends DelegateIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static enum Serializer implements IIngredientSerializer<NotIngredient>
    {
        INSTANCE;


        public NotIngredient parse(FriendlyByteBuf buffer) {
            Ingredient internal = Helpers.decodeNullable(buffer, Ingredient::m_43940_);
            return new NotIngredient(internal);
        }

        public NotIngredient parse(JsonObject json) {
            Ingredient internal = json.has("ingredient") ? Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingredient")) : null;
            return new NotIngredient(internal);
        }

        public void write(FriendlyByteBuf buffer, NotIngredient ingredient) {
            Helpers.encodeNullable(ingredient.delegate, buffer, Ingredient::m_43923_);
        }
    }
}

