/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public interface IngredientType<T>
extends Predicate<T> {
    public static <T, I extends IngredientType<T>> I fromJson(JsonElement json, Factory<T, I> factory) {
        if (json.isJsonPrimitive()) {
            Object object = JsonHelpers.getRegistryEntry(json, factory.registry);
            return IngredientType.of(object, factory);
        }
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has(factory.key) && obj.has("tag")) {
                throw new JsonParseException(factory.key + " ingredient cannot have both '" + factory.key + "' and 'tag' entries");
            }
            if (obj.has(factory.key)) {
                Object object = JsonHelpers.getRegistryEntry(obj, factory.key, factory.registry);
                return IngredientType.of(object, factory);
            }
            if (obj.has("tag")) {
                TagKey tag = JsonHelpers.getTag(obj, "tag", factory.registry.m_123023_());
                return IngredientType.of(tag, factory);
            }
            throw new JsonParseException("Fluid ingredient must have one of 'fluid' or 'tag' entries");
        }
        JsonArray array = JsonHelpers.m_13924_((JsonElement)json, (String)"ingredient");
        ArrayList<Entry<T>> entries = new ArrayList<Entry<T>>();
        for (JsonElement element : array) {
            entries.addAll(IngredientType.fromJson(element, factory).entries());
        }
        return (I)((IngredientType)factory.factory.apply(entries));
    }

    public static <T, I extends IngredientType<T>> JsonElement toJson(I ingredient, Factory<T, I> factory) {
        List<Entry<Entry>> entries = ingredient.entries();
        if (entries.size() == 1) {
            return IngredientType.toJson(entries.get(0), factory);
        }
        JsonArray json = new JsonArray(entries.size());
        entries.forEach(entry -> json.add(IngredientType.toJson(entry, factory)));
        return json;
    }

    private static <T, I extends IngredientType<T>> I of(T object, Factory<T, I> factory) {
        return (I)((IngredientType)factory.factory.apply(List.of(new ObjEntry<T>(object))));
    }

    private static <T, I extends IngredientType<T>> I of(TagKey<T> tag, Factory<T, I> factory) {
        return (I)((IngredientType)factory.factory.apply(List.of(factory.tagEntry.apply(tag))));
    }

    private static <T, I extends IngredientType<T>> JsonElement toJson(Entry<T> entry, Factory<T, I> factory) {
        JsonObject obj = new JsonObject();
        if (entry instanceof ObjEntry) {
            ObjEntry objEntry = (ObjEntry)entry;
            obj.addProperty(factory.key, Objects.requireNonNull(factory.registry.m_7981_(objEntry.object)).toString());
        } else {
            obj.addProperty("tag", ((TagEntry)entry).tag().f_203868_().toString());
        }
        return obj;
    }

    public static <T, I extends IngredientType<T>> void toNetwork(FriendlyByteBuf buffer, I ingredient, Factory<T, I> factory) {
        Helpers.encodeAll(buffer, ingredient.entries(), (entry, buf) -> {
            if (entry instanceof ObjEntry) {
                ObjEntry objEntry = (ObjEntry)entry;
                buf.writeByte(0);
                buf.m_130130_(factory.registry.m_7447_(objEntry.object));
            } else {
                buf.writeByte(1);
                buf.m_130085_(((TagEntry)entry).tag().f_203868_());
            }
        });
    }

    public static <T, I extends IngredientType<T>> I fromNetwork(FriendlyByteBuf buffer, Factory<T, I> factory) {
        return (I)((IngredientType)factory.factory.apply((List)Helpers.decodeAll(buffer, new ArrayList(), buf -> {
            if (buf.readByte() == 0) {
                Object object = factory.registry.m_7942_(buffer.m_130242_());
                return new ObjEntry<Object>(object);
            }
            TagKey tag = TagKey.m_203882_((ResourceKey)factory.registry.m_123023_(), (ResourceLocation)buf.m_130281_());
            return factory.tagEntry.apply(tag);
        })));
    }

    public List<Entry<T>> entries();

    default public Stream<T> all() {
        return this.entries().stream().flatMap(Entry::stream);
    }

    public JsonElement toJson();

    public void toNetwork(FriendlyByteBuf var1);

    @Override
    default public boolean test(T object) {
        for (Entry<T> entry : this.entries()) {
            if (!entry.test(object)) continue;
            return true;
        }
        return false;
    }

    public record Factory<T, I extends IngredientType<T>>(String key, DefaultedRegistry<T> registry, Function<TagKey<T>, Entry<T>> tagEntry, Function<List<Entry<T>>, I> factory) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Entry<T>
    extends Predicate<T> {
        public Stream<T> stream();
    }

    public record ObjEntry<T>(T object) implements Entry<T>
    {
        @Override
        public boolean test(T object) {
            return this.object == object;
        }

        @Override
        public Stream<T> stream() {
            return Stream.of(this.object);
        }
    }

    public static interface TagEntry<T>
    extends Entry<T> {
        public TagKey<T> tag();
    }
}

