/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.dries007.tfc.common.recipes.ingredients.IngredientType;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public record FluidIngredient(List<IngredientType.Entry<Fluid>> entries) implements IngredientType<Fluid>
{
    private static final IngredientType.Factory<Fluid, FluidIngredient> FACTORY = new IngredientType.Factory("fluid", BuiltInRegistries.f_257020_, FluidTag::new, FluidIngredient::new);

    public static FluidIngredient fromJson(JsonElement json) {
        return IngredientType.fromJson(json, FACTORY);
    }

    public static FluidIngredient fromNetwork(FriendlyByteBuf buffer) {
        return IngredientType.fromNetwork(buffer, FACTORY);
    }

    public Collection<Fluid> fluids() {
        return this.all().toList();
    }

    @Override
    public JsonElement toJson() {
        return IngredientType.toJson(this, FACTORY);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        IngredientType.toNetwork(buffer, this, FACTORY);
    }

    public record FluidTag(TagKey<Fluid> tag) implements IngredientType.TagEntry<Fluid>
    {
        @Override
        public Stream<Fluid> stream() {
            return Helpers.allFluids(this.tag);
        }

        @Override
        public boolean test(Fluid fluid) {
            return Helpers.isFluid(fluid, this.tag);
        }
    }
}

