/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import net.dries007.tfc.common.capabilities.forge.ForgingBonus;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WeldingRecipe
implements ISimpleRecipe<Inventory> {
    private final ResourceLocation id;
    private final Ingredient firstInput;
    private final Ingredient secondInput;
    private final int tier;
    private final ItemStackProvider output;
    private final Behavior bonus;
    private final boolean combineForgingBonus;

    public WeldingRecipe(ResourceLocation id, Ingredient firstInput, Ingredient secondInput, int tier, ItemStackProvider output, boolean combineForgingBonus, Behavior bonus) {
        this.id = id;
        this.firstInput = firstInput;
        this.secondInput = secondInput;
        this.tier = tier;
        this.output = output;
        this.combineForgingBonus = combineForgingBonus;
        this.bonus = bonus;
    }

    public boolean isCorrectTier(int anvilTier) {
        return anvilTier >= this.tier;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean matches(Inventory inventory, Level level) {
        ItemStack left = inventory.getLeft();
        ItemStack right = inventory.getRight();
        return this.firstInput.test(left) && this.secondInput.test(right) || this.firstInput.test(right) && this.secondInput.test(left);
    }

    public ItemStack assemble(Inventory inventory, RegistryAccess registryAccess) {
        ItemStack stack = this.output.getSingleStack(inventory.getLeft());
        if (this.bonus != Behavior.IGNORE) {
            ForgingBonus left = ForgingBonus.get(inventory.getLeft());
            ForgingBonus right = ForgingBonus.get(inventory.getRight());
            boolean leftIsHigher = left.ordinal() > right.ordinal();
            boolean copyHigher = this.bonus == Behavior.COPY_BEST;
            ForgingBonus.copy(leftIsHigher == copyHigher ? inventory.getLeft() : inventory.getRight(), stack);
        } else if (this.combineForgingBonus) {
            ForgingBonus left = ForgingBonus.get(inventory.getLeft());
            ForgingBonus right = ForgingBonus.get(inventory.getRight());
            if (left.ordinal() < right.ordinal()) {
                ForgingBonus.set(stack, left);
            } else {
                ForgingBonus.set(stack, right);
            }
        }
        return stack;
    }

    public ItemStack m_8043_(@Nullable RegistryAccess access) {
        return this.output.getEmptyStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.WELDING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.WELDING.get();
    }

    public Ingredient getFirstInput() {
        return this.firstInput;
    }

    public Ingredient getSecondInput() {
        return this.secondInput;
    }

    public boolean shouldCombineForgingBonus() {
        return this.combineForgingBonus;
    }

    public static enum Behavior implements StringRepresentable
    {
        COPY_BEST,
        COPY_WORST,
        IGNORE;


        public static Behavior from(String name) {
            try {
                return Behavior.valueOf(name.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                return IGNORE;
            }
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static interface Inventory
    extends EmptyInventory {
        public ItemStack getLeft();

        public ItemStack getRight();

        public int getTier();
    }

    public static class Serializer
    extends RecipeSerializerImpl<WeldingRecipe> {
        public WeldingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient firstInput = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "first_input"));
            Ingredient secondInput = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "second_input"));
            int tier = JsonHelpers.m_13824_((JsonObject)json, (String)"tier", (int)-1);
            ItemStackProvider output = ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            boolean combineForging = JsonHelpers.m_13855_((JsonObject)json, (String)"combine_forging_bonus", (boolean)false);
            Behavior bonus = Behavior.from(JsonHelpers.m_13851_((JsonObject)json, (String)"bonus", (String)"ignore"));
            return new WeldingRecipe(recipeId, firstInput, secondInput, tier, output, combineForging, bonus);
        }

        @Nullable
        public WeldingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient firstInput = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient secondInput = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int tier = buffer.m_130242_();
            ItemStackProvider output = ItemStackProvider.fromNetwork(buffer);
            boolean combineForging = buffer.readBoolean();
            Behavior bonus = Behavior.from(buffer.m_130277_());
            return new WeldingRecipe(recipeId, firstInput, secondInput, tier, output, combineForging, bonus);
        }

        public void toNetwork(FriendlyByteBuf buffer, WeldingRecipe recipe) {
            recipe.firstInput.m_43923_(buffer);
            recipe.secondInput.m_43923_(buffer);
            buffer.m_130130_(recipe.tier);
            recipe.output.toNetwork(buffer);
            buffer.writeBoolean(recipe.combineForgingBonus);
            buffer.m_130070_(recipe.bonus.m_7912_());
        }
    }
}

