/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.SimpleItemRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.ItemStackIngredient;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LoomRecipe
extends SimpleItemRecipe {
    public static final IndirectHashCollection<Item, LoomRecipe> CACHE = IndirectHashCollection.createForRecipe(SimpleItemRecipe::getValidItems, TFCRecipeTypes.LOOM);
    private final ItemStackIngredient ingredient;
    private final int stepsRequired;
    private final ResourceLocation inProgressTexture;

    @Nullable
    public static LoomRecipe getRecipe(Level level, ItemStack stack) {
        return LoomRecipe.getRecipe(level, new ItemStackInventory(stack));
    }

    @Nullable
    public static LoomRecipe getRecipe(Level level, ItemStackInventory wrapper) {
        for (LoomRecipe recipe : CACHE.getAll(wrapper.getStack().m_41720_())) {
            if (!recipe.matches(wrapper, level)) continue;
            return recipe;
        }
        return null;
    }

    public LoomRecipe(ResourceLocation id, ItemStackIngredient ingredient, ItemStackProvider result, int stepsRequired, ResourceLocation inProgressTexture) {
        super(id, ingredient.ingredient(), result);
        this.ingredient = ingredient;
        this.stepsRequired = stepsRequired;
        this.inProgressTexture = inProgressTexture;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.LOOM.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.LOOM.get();
    }

    public ItemStackIngredient getItemStackIngredient() {
        return this.ingredient;
    }

    public int getInputCount() {
        return this.ingredient.count();
    }

    public ResourceLocation getInProgressTexture() {
        return this.inProgressTexture;
    }

    public int getStepCount() {
        return this.stepsRequired;
    }

    public static class Serializer
    extends RecipeSerializerImpl<LoomRecipe> {
        public LoomRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStackIngredient ingredient = ItemStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"ingredient"));
            ItemStackProvider stack = ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            int stepsRequired = JsonHelpers.m_13927_((JsonObject)json, (String)"steps_required");
            ResourceLocation inProgressTexture = JsonHelpers.getResourceLocation(json, "in_progress_texture");
            return new LoomRecipe(recipeId, ingredient, stack, stepsRequired, inProgressTexture);
        }

        @Nullable
        public LoomRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStackIngredient ingredient = ItemStackIngredient.fromNetwork(buffer);
            ItemStackProvider stack = ItemStackProvider.fromNetwork(buffer);
            int steps = buffer.m_130242_();
            ResourceLocation inProgressTexture = buffer.m_130281_();
            return new LoomRecipe(recipeId, ingredient, stack, steps, inProgressTexture);
        }

        public void toNetwork(FriendlyByteBuf buffer, LoomRecipe recipe) {
            recipe.ingredient.toNetwork(buffer);
            recipe.result.toNetwork(buffer);
            buffer.m_130130_(recipe.stepsRequired);
            buffer.m_130070_(recipe.inProgressTexture.toString());
        }
    }
}

