/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.ingredients.ItemStackIngredient;
import net.dries007.tfc.common.recipes.inventory.BarrelInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class InstantFluidBarrelRecipe
extends BarrelRecipe {
    private final FluidStackIngredient addedFluid;

    public InstantFluidBarrelRecipe(ResourceLocation id, BarrelRecipe.Builder builder, FluidStackIngredient addedFluid) {
        super(id, builder);
        this.addedFluid = addedFluid;
    }

    public FluidStackIngredient getAddedFluid() {
        return this.addedFluid;
    }

    @Override
    public boolean matches(BarrelInventory container, @Nullable Level level) {
        return this.matches(container.getStackInSlot(2), container.getFluidInTank(0)) || this.matches(container.getStackInSlot(0), container.getFluidInTank(0));
    }

    public boolean matches(ItemStack inputStack, FluidStack fluidStack) {
        FluidStack extractableFluid = inputStack.getCapability(Capabilities.FLUID_ITEM).map(cap -> cap.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).orElse(FluidStack.EMPTY);
        return this.inputFluid.test(fluidStack) && this.addedFluid.test(extractableFluid);
    }

    @Override
    public void assembleOutputs(BarrelInventory inventory) {
        inventory.whileMutable(() -> {
            FluidStack primaryFluid = inventory.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            boolean inputIsItemSlot = this.matches(inventory.getStackInSlot(2), primaryFluid);
            ItemStack originalStack = Helpers.removeStack((IItemHandler)inventory, inputIsItemSlot ? 2 : 0);
            IFluidHandlerItem fluidHandler = Helpers.getCapability((ICapabilityProvider)originalStack.m_255036_(1), Capabilities.FLUID_ITEM);
            if (fluidHandler == null) {
                return;
            }
            FluidStack addedFluid = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            int multiplier = Math.min(primaryFluid.getAmount() / this.inputFluid.amount(), addedFluid.getAmount() / this.addedFluid.amount());
            int targetAddedFluid = multiplier * this.addedFluid.amount();
            FluidStack actualAddedFluid = fluidHandler.drain(targetAddedFluid, IFluidHandler.FluidAction.SIMULATE);
            if (actualAddedFluid.isEmpty() || actualAddedFluid.getAmount() < targetAddedFluid) {
                fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            } else {
                fluidHandler.drain(targetAddedFluid, IFluidHandler.FluidAction.EXECUTE);
            }
            FluidStack outputFluid = this.outputFluid.copy();
            outputFluid.setAmount(Math.min((Integer)TFCConfig.SERVER.barrelCapacity.get(), outputFluid.getAmount() * multiplier));
            inventory.fill(outputFluid, IFluidHandler.FluidAction.EXECUTE);
            FluidHelpers.updateContainerItem(originalStack, fluidHandler, (newOriginalStack, newContainerStack) -> {
                inventory.setStackInSlot(inputIsItemSlot ? 2 : 1, newOriginalStack);
                if (!newContainerStack.m_41619_()) {
                    inventory.insertItemWithOverflow(newContainerStack);
                }
            });
        });
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.INSTANT_FLUID_BARREL.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.BARREL_INSTANT_FLUID.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<InstantFluidBarrelRecipe> {
        public InstantFluidBarrelRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            FluidStackIngredient primaryFluid = FluidStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"primary_fluid"));
            FluidStackIngredient addedFluid = FluidStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"added_fluid"));
            FluidStack outputFluid = JsonHelpers.getFluidStack(json, "output_fluid");
            SoundEvent sound = json.has("sound") ? (SoundEvent)JsonHelpers.getRegistryEntry(json, "sound", BuiltInRegistries.f_256894_) : SoundEvents.f_11772_;
            return new InstantFluidBarrelRecipe(recipeId, new BarrelRecipe.Builder(ItemStackIngredient.EMPTY, primaryFluid, ItemStackProvider.empty(), outputFluid, sound), addedFluid);
        }

        @Nullable
        public InstantFluidBarrelRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            BarrelRecipe.Builder builder = BarrelRecipe.Builder.fromNetworkFluidsOnly(buffer);
            FluidStackIngredient addedFluid = FluidStackIngredient.fromNetwork(buffer);
            return new InstantFluidBarrelRecipe(recipeId, builder, addedFluid);
        }

        public void toNetwork(FriendlyByteBuf buffer, InstantFluidBarrelRecipe recipe) {
            BarrelRecipe.Builder.toNetworkFluidsOnly(recipe, buffer);
            recipe.addedFluid.toNetwork(buffer);
        }
    }
}

