/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.capabilities.glass.GlassOperation;
import net.dries007.tfc.common.capabilities.glass.GlassWorkData;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GlassworkingRecipe
implements ISimpleRecipe<ItemStackInventory> {
    private final ResourceLocation id;
    private final List<GlassOperation> operations;
    private final Ingredient batchItem;
    private final ItemStack resultItem;

    public GlassworkingRecipe(ResourceLocation id, List<GlassOperation> operations, Ingredient batchItem, ItemStack resultItem) {
        this.id = id;
        this.operations = operations;
        this.batchItem = batchItem;
        this.resultItem = resultItem;
    }

    public boolean matches(ItemStackInventory inv, Level level) {
        GlassWorkData data = GlassWorkData.get(inv.getStack());
        if (data != null) {
            List<GlassOperation> steps = data.getOperations().getSteps();
            return steps.equals(this.operations) && this.batchItem.test(data.getBatch());
        }
        return false;
    }

    public ItemStack m_8043_(@Nullable RegistryAccess access) {
        return this.resultItem.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.GLASSWORKING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.GLASSWORKING.get();
    }

    public Ingredient getBatchItem() {
        return this.batchItem;
    }

    public List<GlassOperation> getOperations() {
        return this.operations;
    }

    public static class Serializer
    extends RecipeSerializerImpl<GlassworkingRecipe> {
        public GlassworkingRecipe fromJson(ResourceLocation id, JsonObject json) {
            ArrayList<GlassOperation> operations = new ArrayList<GlassOperation>();
            for (JsonElement element : json.getAsJsonArray("operations")) {
                operations.add(JsonHelpers.getEnum(element, GlassOperation.class));
            }
            Ingredient batch = Ingredient.m_43917_((JsonElement)json.get("batch"));
            ItemStack result = JsonHelpers.getItemStack(json, "result");
            return new GlassworkingRecipe(id, operations, batch, result);
        }

        public GlassworkingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int capacity = buffer.m_130242_();
            ArrayList<GlassOperation> ops = new ArrayList<GlassOperation>(capacity);
            for (int i = 0; i < capacity; ++i) {
                ops.add((GlassOperation)buffer.m_130066_(GlassOperation.class));
            }
            Ingredient batch = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new GlassworkingRecipe(id, ops, batch, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, GlassworkingRecipe recipe) {
            buffer.m_130130_(recipe.operations.size());
            for (GlassOperation op : recipe.operations) {
                buffer.m_130068_((Enum)op);
            }
            recipe.batchItem.m_43923_(buffer);
            buffer.m_130055_(recipe.resultItem);
        }
    }
}

