/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FoodCombiningCraftingRecipe
extends CustomRecipe
implements ISimpleRecipe<CraftingContainer> {
    public FoodCombiningCraftingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        int notEmptyCount = 0;
        ItemStack foodStack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++notEmptyCount;
            if (!FoodCapability.has(stack)) {
                return false;
            }
            if (foodStack.m_41619_()) {
                foodStack = stack;
                continue;
            }
            if (FoodCapability.areStacksStackableExceptCreationDate(stack, foodStack)) continue;
            return false;
        }
        return notEmptyCount > 1;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack resultStack = ItemStack.f_41583_;
        int outputAmount = 0;
        long minCreationDate = -1L;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            IFood cap;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || (cap = FoodCapability.get(stack)) == null) continue;
            ++outputAmount;
            if (minCreationDate == -1L || minCreationDate > cap.getCreationDate()) {
                minCreationDate = cap.getCreationDate();
            }
            if (!resultStack.m_41619_()) continue;
            resultStack = stack.m_41777_();
        }
        resultStack.m_41764_(outputAmount);
        long date = minCreationDate;
        FoodCapability.setCreationDate(resultStack, date);
        return resultStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        return NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.FOOD_COMBINING_CRAFTING.get();
    }
}

