/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import java.util.Locale;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.player.PlayerData;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.SimpleBlockRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ChiselRecipe
extends SimpleBlockRecipe {
    public static final IndirectHashCollection<Block, ChiselRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getBlockIngredient().blocks(), TFCRecipeTypes.CHISEL);
    private final Mode mode;
    @Nullable
    private final Ingredient itemIngredient;
    private final ItemStackProvider extraDrop;

    public static Either<BlockState, InteractionResult> computeResult(Player player, BlockState state, BlockHitResult hit, boolean informWhy) {
        ItemStack held = player.m_21205_();
        if (Helpers.isItem(held, TFCTags.Items.CHISELS) && Helpers.isItem(player.m_21206_(), TFCTags.Items.HAMMERS)) {
            Block block;
            BlockPos pos = hit.m_82425_();
            Mode mode = PlayerData.get(player).getChiselMode();
            ChiselRecipe recipe = ChiselRecipe.getRecipe(state, held, mode);
            if (recipe == null) {
                if (informWhy) {
                    ChiselRecipe.complain(player, "no_recipe");
                }
                return Either.right((Object)InteractionResult.PASS);
            }
            @Nullable BlockState chiseled = recipe.getBlockCraftingResult(state);
            if (mode == Mode.STAIR && (block = chiseled.m_60734_()) instanceof StairBlock) {
                StairBlock stair = (StairBlock)block;
                chiseled = stair.m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)stair), hit));
                if (chiseled != null) {
                    chiseled = FluidHelpers.fillWithFluid(chiseled, state.m_60819_().m_76152_());
                }
            } else if (mode == Mode.SLAB && chiseled.m_60734_() instanceof SlabBlock && chiseled.m_61138_((Property)SlabBlock.f_56353_)) {
                Direction hitFace = hit.m_82434_();
                SlabType slabType = !(hitFace == Direction.DOWN || hitFace != Direction.UP && hit.m_82450_().f_82480_ - (double)pos.m_123342_() > 0.5) ? SlabType.BOTTOM : SlabType.TOP;
                chiseled = (BlockState)chiseled.m_61124_((Property)SlabBlock.f_56353_, (Comparable)slabType);
                chiseled = FluidHelpers.fillWithFluid(chiseled, state.m_60819_().m_76152_());
            }
            if (chiseled == null) {
                if (informWhy) {
                    ChiselRecipe.complain(player, "cannot_place");
                }
                return Either.right((Object)InteractionResult.FAIL);
            }
            return Either.left((Object)chiseled);
        }
        return Either.right((Object)InteractionResult.PASS);
    }

    private static void complain(Player player, String message) {
        player.m_5661_((Component)Component.m_237115_((String)("tfc.chisel." + message)), true);
    }

    @Nullable
    public static ChiselRecipe getRecipe(BlockState state, ItemStack held, Mode mode) {
        for (ChiselRecipe recipe : CACHE.getAll(state.m_60734_())) {
            if (!recipe.matches(state, held, mode)) continue;
            return recipe;
        }
        return null;
    }

    public ChiselRecipe(ResourceLocation id, BlockIngredient ingredient, BlockState outputState, Mode mode, @Nullable Ingredient itemIngredient, ItemStackProvider extraDrop) {
        super(id, ingredient, outputState, false);
        this.mode = mode;
        this.itemIngredient = itemIngredient;
        this.extraDrop = extraDrop;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.CHISEL.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.CHISEL.get();
    }

    public boolean matches(BlockState state, ItemStack stack, Mode mode) {
        if (this.itemIngredient != null && !this.itemIngredient.test(stack)) {
            return false;
        }
        return mode == this.mode && this.matches(state);
    }

    public Mode getMode() {
        return this.mode;
    }

    @Nullable
    public Ingredient getItemIngredient() {
        return this.itemIngredient;
    }

    public ItemStack getExtraDrop(ItemStack chisel) {
        return this.extraDrop.getSingleStack(chisel);
    }

    public static enum Mode implements StringRepresentable
    {
        SMOOTH,
        STAIR,
        SLAB;

        public static final Mode[] VALUES;

        public static Mode valueOf(int i) {
            return i >= 0 && i < VALUES.length ? VALUES[i] : SMOOTH;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public Mode next() {
            return Mode.valueOf(this.ordinal() + 1);
        }

        static {
            VALUES = Mode.values();
        }
    }

    public static class Serializer
    extends RecipeSerializerImpl<ChiselRecipe> {
        public ChiselRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            BlockIngredient ingredient = BlockIngredient.fromJson(JsonHelpers.get(json, "ingredient"));
            BlockState state = JsonHelpers.getBlockState(GsonHelper.m_13906_((JsonObject)json, (String)"result"));
            Mode mode = JsonHelpers.getEnum(json, "mode", Mode.class, Mode.SMOOTH);
            Ingredient itemIngredient = json.has("item_ingredient") ? Ingredient.m_43917_((JsonElement)json.get("item_ingredient")) : null;
            ItemStackProvider drop = json.has("extra_drop") ? ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"extra_drop")) : ItemStackProvider.empty();
            return new ChiselRecipe(recipeId, ingredient, state, mode, itemIngredient, drop);
        }

        @Nullable
        public ChiselRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            BlockIngredient ingredient = BlockIngredient.fromNetwork(buffer);
            BlockState state = ((Block)BuiltInRegistries.f_256975_.m_7942_(buffer.m_130242_())).m_49966_();
            Mode mode = (Mode)buffer.m_130066_(Mode.class);
            Ingredient itemIngredient = Helpers.decodeNullable(buffer, Ingredient::m_43940_);
            ItemStackProvider drop = ItemStackProvider.fromNetwork(buffer);
            return new ChiselRecipe(recipeId, ingredient, state, mode, itemIngredient, drop);
        }

        public void toNetwork(FriendlyByteBuf buffer, ChiselRecipe recipe) {
            recipe.ingredient.toNetwork(buffer);
            buffer.m_130130_(BuiltInRegistries.f_256975_.m_7447_((Object)recipe.outputState.m_60734_()));
            buffer.m_130068_((Enum)recipe.getMode());
            Helpers.encodeNullable(recipe.itemIngredient, buffer, Ingredient::m_43923_);
            recipe.extraDrop.toNetwork(buffer);
        }
    }
}

