/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.ingredients.ItemStackIngredient;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class BloomeryRecipe
implements ISimpleRecipe<EmptyInventory> {
    private final ResourceLocation id;
    private final FluidStackIngredient inputFluid;
    private final ItemStackIngredient catalyst;
    private final ItemStackProvider result;
    private final int duration;

    public BloomeryRecipe(ResourceLocation id, FluidStackIngredient inputFluid, ItemStackIngredient catalyst, ItemStackProvider result, int duration) {
        this.id = id;
        this.inputFluid = inputFluid;
        this.catalyst = catalyst;
        this.result = result;
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public ItemStackIngredient getCatalyst() {
        return this.catalyst;
    }

    public FluidStackIngredient getInputFluid() {
        return this.inputFluid;
    }

    public boolean matches(EmptyInventory inv, Level level) {
        return false;
    }

    public boolean matchesInput(ItemStack stack) {
        return this.consumeInput(stack) != null;
    }

    public boolean matchesInput(FluidStack stack) {
        return this.inputFluid.ingredient().test(stack.getFluid());
    }

    @Nullable
    public FluidStack consumeInput(ItemStack stack) {
        FluidStack fluid;
        ItemStackInventory inventory = new ItemStackInventory(stack);
        HeatingRecipe heat = HeatingRecipe.getRecipe(inventory);
        if (heat != null && this.matchesInput(fluid = heat.assembleFluid(inventory))) {
            return fluid;
        }
        return null;
    }

    public boolean matchesCatalyst(ItemStack stack) {
        return this.catalyst.test(stack);
    }

    public ItemStack assembleOutput() {
        return this.result.getEmptyStack();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.getEmptyStack();
    }

    public ItemStack assemble(EmptyInventory inventory, RegistryAccess registryAccess) {
        throw new UnsupportedOperationException();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.BLOOMERY.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.BLOOMERY.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<BloomeryRecipe> {
        public BloomeryRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            FluidStackIngredient fluidStack = FluidStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"fluid"));
            ItemStackIngredient catalyst = ItemStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"catalyst"));
            ItemStackProvider result = ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            int time = JsonHelpers.m_13927_((JsonObject)json, (String)"duration");
            return new BloomeryRecipe(recipeId, fluidStack, catalyst, result, time);
        }

        @Nullable
        public BloomeryRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            FluidStackIngredient fluidStack = FluidStackIngredient.fromNetwork(buffer);
            ItemStackIngredient catalyst = ItemStackIngredient.fromNetwork(buffer);
            ItemStackProvider result = ItemStackProvider.fromNetwork(buffer);
            int time = buffer.m_130242_();
            return new BloomeryRecipe(recipeId, fluidStack, catalyst, result, time);
        }

        public void toNetwork(FriendlyByteBuf buffer, BloomeryRecipe recipe) {
            recipe.inputFluid.toNetwork(buffer);
            recipe.catalyst.toNetwork(buffer);
            recipe.result.toNetwork(buffer);
            buffer.m_130130_(recipe.duration);
        }
    }
}

