/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AdvancedShapelessRecipe
extends ShapelessRecipe {
    protected final ItemStackProvider result;
    @Nullable
    protected final Ingredient primaryIngredient;

    public AdvancedShapelessRecipe(ResourceLocation id, String group, ItemStackProvider result, NonNullList<Ingredient> ingredients, @Nullable Ingredient primaryIngredient) {
        super(id, group, CraftingBookCategory.MISC, result.getEmptyStack(), ingredients);
        this.result = result;
        this.primaryIngredient = primaryIngredient;
    }

    public boolean m_5818_(CraftingContainer inv, Level level) {
        return super.m_5818_(inv, level) && (this.primaryIngredient == null || !this.getSeed(inv).m_41619_());
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        RecipeHelpers.setCraftingInput(inventory);
        ItemStack result = this.result.getSingleStack(this.getSeed(inventory).m_41777_());
        RecipeHelpers.clearCraftingInput();
        return result;
    }

    public ItemStackProvider getResult() {
        return this.result;
    }

    @Nullable
    public Ingredient getPrimaryIngredient() {
        return this.primaryIngredient;
    }

    private ItemStack getSeed(CraftingContainer inv) {
        if (this.primaryIngredient == null) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack item = inv.m_8020_(i);
            if (!this.primaryIngredient.test(item)) continue;
            return item;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return this.result.dependsOnInput();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.ADVANCED_SHAPELESS_CRAFTING.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<AdvancedShapelessRecipe> {
        public AdvancedShapelessRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = JsonHelpers.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = RecipeHelpers.itemsFromJson(JsonHelpers.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty() || ingredients.size() > 9) {
                throw new JsonParseException("ingredients should be 1 to 9 ingredients long, it was: " + ingredients.size());
            }
            ItemStackProvider result = ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            Ingredient primaryIngredient = json.has("primary_ingredient") ? Ingredient.m_43917_((JsonElement)json.get("primary_ingredient")) : null;
            return new AdvancedShapelessRecipe(id, group, result, ingredients, primaryIngredient);
        }

        @Nullable
        public AdvancedShapelessRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            int size = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStackProvider result = ItemStackProvider.fromNetwork(buffer);
            Ingredient primaryIngredient = Helpers.decodeNullable(buffer, Ingredient::m_43940_);
            return new AdvancedShapelessRecipe(id, group, result, (NonNullList<Ingredient>)ingredients, primaryIngredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, AdvancedShapelessRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            recipe.result.toNetwork(buffer);
            Helpers.encodeNullable(recipe.primaryIngredient, buffer, Ingredient::m_43923_);
        }
    }
}

