/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.items.ProspectResult;
import net.dries007.tfc.common.items.ToolItem;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.ProspectedPacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.ProspectedEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class PropickItem
extends ToolItem {
    public static final int RADIUS = 12;
    public static final int COOLDOWN = 10;
    private static final Map<Block, Block> REPRESENTATIVE_BLOCKS = new IdentityHashMap<Block, Block>();
    private final float falseNegativeChance;

    public static synchronized void registerRepresentative(Block representative, Block ... blocks) {
        for (Block block : blocks) {
            REPRESENTATIVE_BLOCKS.put(block, representative);
        }
    }

    public static Block getRepresentative(Block block) {
        return REPRESENTATIVE_BLOCKS.getOrDefault(block, block);
    }

    public static void registerDefaultRepresentativeBlocks() {
        TFCBlocks.GRADED_ORES.forEach((rock, ores) -> ores.forEach((ore, blocks) -> PropickItem.registerRepresentative((Block)((RegistryObject)blocks.get((Object)Ore.Grade.NORMAL)).get(), (Block)((RegistryObject)blocks.get((Object)Ore.Grade.RICH)).get(), (Block)((RegistryObject)blocks.get((Object)Ore.Grade.POOR)).get())));
    }

    public static Object2IntMap<Block> scanAreaFor(Level level, BlockPos center, int radius, TagKey<Block> tag) {
        Object2IntOpenHashMap results = new Object2IntOpenHashMap();
        for (BlockPos cursor : BlockPos.m_121976_((int)(center.m_123341_() - radius), (int)(center.m_123342_() - radius), (int)(center.m_123343_() - radius), (int)(center.m_123341_() + radius), (int)(center.m_123342_() + radius), (int)(center.m_123343_() + radius))) {
            Block block = PropickItem.getRepresentative(level.m_8055_(cursor).m_60734_());
            if (!Helpers.isBlock(block, tag)) continue;
            results.mergeInt((Object)block, 1, Integer::sum);
        }
        return results;
    }

    public PropickItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, TFCTags.Blocks.MINEABLE_WITH_PROPICK, properties);
        this.falseNegativeChance = 0.3f - (float)Mth.m_14045_((int)tier.m_6604_(), (int)0, (int)5) * 0.060000002f;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        if (player instanceof ServerPlayer) {
            ArrayList stateKeys;
            int amount;
            Object2IntMap<Block> states;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundType sound = state.getSoundType((LevelReader)level, pos, (Entity)player);
            Random random = new Random();
            level.m_5594_(player, pos, sound.m_56778_(), SoundSource.PLAYERS, sound.m_56773_(), sound.m_56774_());
            context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            player.m_36335_().m_41524_((Item)this, 10);
            Block found = state.m_60734_();
            random.setSeed(Helpers.hash(19827384739241223L, pos));
            ProspectResult result = Helpers.isBlock(state, TFCTags.Blocks.PROSPECTABLE) ? ProspectResult.FOUND : (random.nextFloat() < this.falseNegativeChance ? ProspectResult.NOTHING : ((states = PropickItem.scanAreaFor(level, pos, 12, TFCTags.Blocks.PROSPECTABLE)).isEmpty() ? ProspectResult.NOTHING : ((amount = states.getOrDefault((Object)(found = (Block)(stateKeys = new ArrayList(states.keySet())).get(random.nextInt(stateKeys.size()))), 1)) < 10 ? ProspectResult.TRACES : (amount < 20 ? ProspectResult.SMALL : (amount < 40 ? ProspectResult.MEDIUM : (amount < 80 ? ProspectResult.LARGE : ProspectResult.VERY_LARGE))))));
            MinecraftForge.EVENT_BUS.post((Event)new ProspectedEvent(player, result, found));
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> serverPlayer), new ProspectedPacket(found, result));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> text, TooltipFlag flag) {
        if (flag.m_7050_()) {
            text.add((Component)Component.m_237110_((String)"tfc.tooltip.propick.accuracy", (Object[])new Object[]{(int)(100.0f * (1.0f - this.falseNegativeChance))}).m_130940_(ChatFormatting.GRAY));
        }
    }
}

