/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.render.blockentity.PanItemRenderer;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Pannable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class PanItem
extends Item {
    public static final int USE_TIME = 120;

    @Nullable
    public static BlockState readState(HolderGetter<Block> getter, ItemStack stack) {
        CompoundTag tag = stack.m_41737_("state");
        if (tag != null) {
            return NbtUtils.m_247651_(getter, (CompoundTag)tag);
        }
        return null;
    }

    @Nullable
    public static Pannable readPannable(HolderGetter<Block> getter, ItemStack stack) {
        BlockState state = PanItem.readState(getter, stack);
        if (state != null) {
            return Pannable.get(state);
        }
        return null;
    }

    public PanItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 120;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        if (Helpers.isFluid(level.m_6425_(player.m_20183_()), TFCTags.Fluids.ANY_INFINITE_WATER)) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        if (!level.f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.pan.water"), true);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int countLeft) {
        if (countLeft % 16 == 0 && !level.f_46443_) {
            level.m_6269_(null, (Entity)entity, (SoundEvent)TFCSounds.PANNING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Pannable pannable = PanItem.readPannable((HolderGetter<Block>)level.m_246945_(Registries.f_256747_), stack);
                if (pannable != null) {
                    LootTable table = level.m_7654_().m_278653_().m_278676_(pannable.getLootTable());
                    LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)stack);
                    ObjectArrayList items = table.m_287195_(builder.m_287235_(LootContextParamSets.f_81414_));
                    items.forEach(item -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item));
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    return new ItemStack((ItemLike)TFCItems.EMPTY_PAN.get());
                }
            }
        }
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> text, TooltipFlag flag) {
        if (level == null) {
            return;
        }
        BlockState state = PanItem.readState((HolderGetter<Block>)level.m_246945_(Registries.f_256747_), stack);
        if (state != null) {
            text.add((Component)Component.m_237115_((String)"tfc.tooltip.pan.contents").m_7220_((Component)state.m_60734_().m_49954_()));
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<PanItemRenderer> renderer = NonNullLazy.of(PanItemRenderer::new);

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.renderer.get();
            }
        });
    }
}

