/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.GlassBasinBlockEntity;
import net.dries007.tfc.common.blockentities.HotPouredGlassBlockEntity;
import net.dries007.tfc.common.blocks.GlassBasinBlock;
import net.dries007.tfc.common.blocks.HotPouredGlassBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.capabilities.glass.GlassOperation;
import net.dries007.tfc.common.capabilities.glass.GlassWorkData;
import net.dries007.tfc.common.items.BlowpipeItem;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemHandlerHelper;

public class GlassBlowpipeItem
extends BlowpipeItem {
    private final float breakChance;

    private static ItemStack getOtherHandItem(Player player) {
        return player.m_21120_(player.m_7655_() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
    }

    private static ItemStack getOtherHandItem(Player player, InteractionHand hand) {
        return player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
    }

    public GlassBlowpipeItem(Item.Properties properties, float breakChance) {
        super(properties);
        this.breakChance = breakChance;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        boolean created;
        ItemStack copy;
        ItemStack item;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Direction face = context.m_43719_();
        Player player = context.m_43723_();
        BlockPos center = pos.m_121945_(face);
        if (GlassBasinBlock.isValid(level, center) && player != null) {
            item = context.m_43722_();
            copy = item.m_41777_();
            GlassWorkData.apply(copy, GlassOperation.BASIN_POUR);
            created = level.m_7465_().m_44015_((RecipeType)TFCRecipeTypes.GLASSWORKING.get(), (Container)new ItemStackInventory(copy), level).map(recipe -> {
                if (!GlassOperation.BASIN_POUR.hasRequiredTemperature(copy)) {
                    player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.glass.not_hot_enough"), true);
                    return false;
                }
                this.consumeBlowpipe(player, context.m_43724_(), item);
                level.m_46597_(center, ((Block)TFCBlocks.GLASS_BASIN.get()).m_49966_());
                BlockEntity patt3813$temp = level.m_7702_(center);
                if (patt3813$temp instanceof GlassBasinBlockEntity) {
                    GlassBasinBlockEntity glass = (GlassBasinBlockEntity)patt3813$temp;
                    glass.setGlassItem(recipe.m_8043_(level.m_9598_()));
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer server = (ServerPlayer)player;
                    TFCAdvancements.BASIN_POUR.trigger(server);
                }
                return true;
            }).orElse(false);
            if (created) {
                return InteractionResult.CONSUME;
            }
        }
        if (face == Direction.UP && Helpers.isBlock(state, TFCTags.Blocks.GLASS_POURING_TABLE) && level.m_8055_(pos.m_7494_()).m_60795_() && player != null) {
            item = context.m_43722_();
            copy = item.m_41777_();
            GlassWorkData.apply(copy, GlassOperation.TABLE_POUR);
            created = level.m_7465_().m_44015_((RecipeType)TFCRecipeTypes.GLASSWORKING.get(), (Container)new ItemStackInventory(copy), level).map(recipe -> {
                if (!GlassOperation.TABLE_POUR.hasRequiredTemperature(copy)) {
                    player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.glass.not_hot_enough"), true);
                    return false;
                }
                this.consumeBlowpipe(player, context.m_43724_(), item);
                level.m_46597_(pos.m_7494_(), (BlockState)((Block)TFCBlocks.HOT_POURED_GLASS.get()).m_49966_().m_61124_((Property)HotPouredGlassBlock.FLAT, (Comparable)Boolean.valueOf(false)));
                BlockEntity patt5438$temp = level.m_7702_(pos.m_7494_());
                if (patt5438$temp instanceof HotPouredGlassBlockEntity) {
                    HotPouredGlassBlockEntity glass = (HotPouredGlassBlockEntity)patt5438$temp;
                    glass.setGlassItem(recipe.m_8043_(level.m_9598_()));
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer server = (ServerPlayer)player;
                    TFCAdvancements.TABLE_POUR.trigger(server);
                }
                return true;
            }).orElse(false);
            if (created) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    protected boolean consumeBlowpipe(Player player, InteractionHand hand, ItemStack item) {
        boolean broken = player.m_217043_().m_188501_() < this.breakChance;
        player.m_21008_(hand, broken ? ItemStack.f_41583_ : BlowpipeItem.transform(item.m_41720_()).m_7968_());
        return broken;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        ItemStack otherItem = GlassBlowpipeItem.getOtherHandItem(player, hand);
        GlassOperation op = GlassOperation.get(otherItem, player);
        if (op != null) {
            if (!op.hasRequiredTemperature(held)) {
                player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.glass.not_hot_enough"), true);
                return InteractionResultHolder.m_19100_((Object)held);
            }
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)held);
        }
        return InteractionResultHolder.m_19098_((Object)held);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int ticksLeft) {
        Player player;
        GlassOperation op;
        if (ticksLeft % 30 == 0 && entity instanceof Player && (op = GlassOperation.get(GlassBlowpipeItem.getOtherHandItem(player = (Player)entity), player)) != null) {
            level.m_5594_(null, entity.m_20183_(), op.getSound(), SoundSource.PLAYERS, 1.0f, 0.8f + (float)(player.m_20154_().f_82480_ / 2.0));
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.stopUsing((LivingEntity)player, stack);
        }
        return super.m_5922_(stack, level, entity);
    }

    protected void stopUsing(LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack otherHand = GlassBlowpipeItem.getOtherHandItem(player);
            GlassOperation op = GlassOperation.get(otherHand, player);
            if (op != null && stack.m_41720_() instanceof GlassBlowpipeItem) {
                GlassWorkData.apply(stack, op);
                Level level = entity.m_9236_();
                level.m_7465_().m_44015_((RecipeType)TFCRecipeTypes.GLASSWORKING.get(), (Container)new ItemStackInventory(stack), level).ifPresent(recipe -> {
                    boolean broken = this.consumeBlowpipe(player, player.m_7655_(), stack);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)recipe.m_8043_(level.m_9598_()));
                    level.m_247517_(null, player.m_20183_(), broken ? SoundEvents.f_12018_ : SoundEvents.f_11887_, SoundSource.PLAYERS);
                });
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            Helpers.allItems(TFCTags.Items.ALL_BLOWPIPES).forEach(item -> player.m_36335_().m_41524_(item, 80));
        }
    }
}

