/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import java.awt.Color;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.Alcohol;
import net.dries007.tfc.common.fluids.ExtendedFluidType;
import net.dries007.tfc.common.fluids.FluidId;
import net.dries007.tfc.common.fluids.FluidRegistryObject;
import net.dries007.tfc.common.fluids.FluidTypeClientProperties;
import net.dries007.tfc.common.fluids.MixingFluid;
import net.dries007.tfc.common.fluids.MoltenFluid;
import net.dries007.tfc.common.fluids.RiverWaterFluid;
import net.dries007.tfc.common.fluids.SimpleFluid;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public final class TFCFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"tfc");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.f_256808_, (String)"tfc");
    public static final ResourceLocation WATER_STILL = Helpers.identifierMC("block/water_still");
    public static final ResourceLocation WATER_FLOW = Helpers.identifierMC("block/water_flow");
    public static final ResourceLocation WATER_OVERLAY = Helpers.identifierMC("block/water_overlay");
    public static final ResourceLocation UNDERWATER_LOCATION = Helpers.identifierMC("textures/misc/underwater.png");
    public static final ResourceLocation MOLTEN_STILL = Helpers.identifier("block/molten_still");
    public static final ResourceLocation MOLTEN_FLOW = Helpers.identifier("block/molten_flow");
    public static final int ALPHA_MASK = -16777216;
    public static final Map<Metal.Default, FluidRegistryObject<ForgeFlowingFluid>> METALS = Helpers.mapOfKeys(Metal.Default.class, metal -> TFCFluids.register("metal/" + metal.m_7912_(), properties -> properties.block((Supplier)TFCBlocks.METAL_FLUIDS.get(metal)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.asType(metal))).explosionResistance(100.0f), TFCFluids.lavaLike().descriptionId("fluid.tfc.metal." + metal.m_7912_()).rarity(metal.getRarity()), new FluidTypeClientProperties(0xFF000000 | metal.getColor(), MOLTEN_STILL, MOLTEN_FLOW, null, null), MoltenFluid.Source::new, MoltenFluid.Flowing::new));
    public static final FluidRegistryObject<ForgeFlowingFluid> SALT_WATER = TFCFluids.register("salt_water", properties -> properties.block(TFCBlocks.SALT_WATER).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.SALT_WATER)), TFCFluids.waterLike().descriptionId("fluid.tfc.salt_water"), new FluidTypeClientProperties(-12618012, (level, pos) -> level.m_6171_(pos, TFCColors.SALT_WATER) | 0xFF000000, WATER_STILL, WATER_FLOW, WATER_OVERLAY, UNDERWATER_LOCATION), MixingFluid.Source::new, MixingFluid.Flowing::new);
    public static final FluidRegistryObject<ForgeFlowingFluid> SPRING_WATER = TFCFluids.register("spring_water", properties -> properties.block(TFCBlocks.SPRING_WATER).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.SPRING_WATER)), TFCFluids.waterLike().descriptionId("fluid.tfc.spring_water"), new FluidTypeClientProperties(-11613225, WATER_STILL, WATER_FLOW, WATER_OVERLAY, UNDERWATER_LOCATION), MixingFluid.Source::new, MixingFluid.Flowing::new);
    public static final RegistryObject<RiverWaterFluid> RIVER_WATER = FLUIDS.register("river_water", RiverWaterFluid::new);
    public static final Map<SimpleFluid, FluidRegistryObject<ForgeFlowingFluid>> SIMPLE_FLUIDS = Helpers.mapOfKeys(SimpleFluid.class, fluid -> TFCFluids.register(fluid.getId(), properties -> properties.block((Supplier)TFCBlocks.SIMPLE_FLUIDS.get(fluid)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.asType(fluid))), TFCFluids.waterLike().descriptionId("fluid.tfc." + fluid.getId()).canConvertToSource(false), new FluidTypeClientProperties(fluid.isTransparent() ? 0xFF000000 | fluid.getColor() : fluid.getColor(), WATER_STILL, WATER_FLOW, WATER_OVERLAY, UNDERWATER_LOCATION), MixingFluid.Source::new, MixingFluid.Flowing::new));
    public static final Map<Alcohol, FluidRegistryObject<ForgeFlowingFluid>> ALCOHOLS = Helpers.mapOfKeys(Alcohol.class, fluid -> TFCFluids.register(fluid.getId(), properties -> properties.block((Supplier)TFCBlocks.ALCOHOLS.get(fluid)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.asType(fluid))), TFCFluids.waterLike().descriptionId("fluid.tfc." + fluid.getId()).canConvertToSource(false), new FluidTypeClientProperties(fluid.getColor(), WATER_STILL, WATER_FLOW, WATER_OVERLAY, null), MixingFluid.Source::new, MixingFluid.Flowing::new));
    public static final Map<DyeColor, FluidRegistryObject<ForgeFlowingFluid>> COLORED_FLUIDS = Helpers.mapOfKeys(DyeColor.class, color -> TFCFluids.register(color.m_41065_() + "_dye", properties -> properties.block((Supplier)TFCBlocks.COLORED_FLUIDS.get(color)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.asType(color))), TFCFluids.waterLike().descriptionId("fluid.tfc." + color.m_41065_() + "_dye").canConvertToSource(false), new FluidTypeClientProperties(TFCFluids.dyeColorToInt(color), WATER_STILL, WATER_FLOW, WATER_OVERLAY, null), MixingFluid.Source::new, MixingFluid.Flowing::new));

    public static int dyeColorToInt(DyeColor dye) {
        float[] colors = dye.m_41068_();
        return new Color(colors[0], colors[1], colors[2]).getRGB();
    }

    private static FluidType.Properties lavaLike() {
        return FluidType.Properties.create().adjacentPathType(BlockPathTypes.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).lightLevel(15).density(3000).viscosity(6000).temperature(1300).canConvertToSource(false).canDrown(false).canExtinguish(false).canHydrate(false).canPushEntity(false).canSwim(false).supportsBoating(false);
    }

    private static FluidType.Properties waterLike() {
        return FluidType.Properties.create().adjacentPathType(BlockPathTypes.WATER).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).canConvertToSource(true).canDrown(true).canExtinguish(true).canHydrate(true).canPushEntity(true).canSwim(true).supportsBoating(true);
    }

    private static <F extends FlowingFluid> FluidRegistryObject<F> register(String name, Consumer<ForgeFlowingFluid.Properties> builder, FluidType.Properties typeProperties, FluidTypeClientProperties clientProperties, Function<ForgeFlowingFluid.Properties, F> sourceFactory, Function<ForgeFlowingFluid.Properties, F> flowingFactory) {
        int index = name.lastIndexOf(47);
        String flowingName = index == -1 ? "flowing_" + name : name.substring(0, index) + "/flowing_" + name.substring(index + 1);
        return RegistrationHelpers.registerFluid(FLUID_TYPES, FLUIDS, name, name, flowingName, builder, () -> new ExtendedFluidType(typeProperties, clientProperties), sourceFactory, flowingFactory);
    }
}

