/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Consumer;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.AqueductBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.fluids.BucketPickupExtension;
import net.dries007.tfc.common.fluids.FlowingFluidExtension;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.mixin.accessor.FlowingFluidAccessor;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public final class FluidHelpers {
    public static final int BUCKET_VOLUME = 1000;

    public static boolean canFluidExtinguishFire(Fluid fluid) {
        return fluid != Fluids.f_76191_ && fluid.getFluidType().getTemperature() < 400;
    }

    public static boolean isInWaterLikeFluid(Entity entity) {
        return entity.isInFluidType((fluidType, value) -> fluidType == TFCFluids.SALT_WATER.type().get() || fluidType == TFCFluids.SPRING_WATER.type().get());
    }

    public static boolean isEyeInWaterLikeFluid(Entity entity) {
        return entity.isEyeInFluidType((FluidType)TFCFluids.SALT_WATER.type().get()) || entity.isEyeInFluidType((FluidType)TFCFluids.SALT_WATER.type().get());
    }

    public static boolean transferBetweenWorldAndItem(ItemStack originalStack, Level level, BlockHitResult target, Player player, InteractionHand hand, boolean allowPlacingAnyLiquidBlocks, boolean allowPlacingSourceBlocks, boolean allowInfiniteSourceFilling) {
        return FluidHelpers.transferBetweenWorldAndItem(originalStack, level, target, new AfterTransferWithPlayer(player, hand), allowPlacingAnyLiquidBlocks, allowPlacingSourceBlocks, allowInfiniteSourceFilling);
    }

    public static boolean transferBetweenWorldAndItem(ItemStack originalStack, Level level, BlockHitResult target, AfterTransfer after, boolean allowPlacingAnyLiquidBlocks, boolean allowPlacingSourceBlocks, boolean allowInfiniteSourceFilling) {
        return target.m_6662_() == HitResult.Type.BLOCK && FluidHelpers.transferBetweenWorldAndItem(originalStack, level, target.m_82425_(), target, after, allowPlacingAnyLiquidBlocks, allowPlacingSourceBlocks, allowInfiniteSourceFilling);
    }

    public static boolean transferBetweenWorldAndItem(ItemStack originalStack, Level level, BlockPos pos, @Nullable BlockHitResult target, AfterTransfer after, boolean allowPlacingAnyLiquidBlocks, boolean allowPlacingSourceBlocks, boolean allowInfiniteSourceFilling) {
        BlockEntity entity;
        BlockState state = level.m_8055_(pos);
        ItemStack stack = originalStack.m_255036_(1);
        IFluidHandlerItem handler = Helpers.getCapability((ICapabilityProvider)stack, Capabilities.FLUID_ITEM);
        if (handler == null) {
            return false;
        }
        FluidStack aggressiveDrained = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (aggressiveDrained.isEmpty()) {
            if (FluidHelpers.pickupFluidInto(level, pos, state, (IFluidHandler)handler, allowInfiniteSourceFilling)) {
                FluidHelpers.updateContainerItem(originalStack, handler, after);
                return true;
            }
        } else if (allowPlacingAnyLiquidBlocks && FluidHelpers.emptyFluidFrom((IFluidHandler)handler, level, pos, state, target, allowPlacingSourceBlocks)) {
            FluidHelpers.updateContainerItem(originalStack, handler, after);
            return true;
        }
        if ((entity = level.m_7702_(pos)) != null) {
            return FluidHelpers.transferBetweenBlockEntityAndItem(originalStack, entity, level, pos, after);
        }
        return false;
    }

    public static boolean transferBetweenBlockEntityAndItem(ItemStack originalStack, BlockEntity entity, Player player, InteractionHand hand) {
        return FluidHelpers.transferBetweenBlockEntityAndItem(originalStack, entity, player.m_9236_(), player.m_20183_(), new AfterTransferWithPlayer(player, hand));
    }

    public static boolean transferBetweenBlockEntityAndItem(ItemStack originalStack, BlockEntity entity, Level level, BlockPos pos, AfterTransfer after) {
        return FluidHelpers.transferBetweenBlockHandlerAndItem(originalStack, Helpers.getCapability((ICapabilityProvider)entity, Capabilities.FLUID), level, pos, after);
    }

    public static boolean transferBetweenBlockHandlerAndItem(ItemStack originalStack, @Nullable IFluidHandler blockHandler, Level level, BlockPos pos, AfterTransfer after) {
        ItemStack stack = originalStack.m_255036_(1);
        IFluidHandlerItem itemHandler = Helpers.getCapability((ICapabilityProvider)stack, Capabilities.FLUID_ITEM);
        if (itemHandler == null || blockHandler == null) {
            return false;
        }
        FluidStack aggressiveDrained = itemHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (aggressiveDrained.isEmpty()) {
            return FluidHelpers.transferBetweenItemAndOther(originalStack, itemHandler, blockHandler, (IFluidHandler)itemHandler, Transfer.FILL, level, pos, after);
        }
        return FluidHelpers.transferBetweenItemAndOther(originalStack, itemHandler, (IFluidHandler)itemHandler, blockHandler, Transfer.DRAIN, level, pos, after);
    }

    public static boolean transferBetweenItemAndOther(ItemStack originalStack, IFluidHandlerItem itemHandler, IFluidHandler from, IFluidHandler to, Transfer type, Level level, BlockPos pos, AfterTransfer after) {
        return FluidHelpers.transferBetweenItemAndOther(originalStack, itemHandler, from, to, fluid -> FluidHelpers.playTransferSound(level, pos, fluid, type), after);
    }

    public static boolean transferBetweenItemAndOther(ItemStack originalStack, IFluidHandlerItem itemHandler, IFluidHandler from, IFluidHandler to, Consumer<FluidStack> sound, AfterTransfer after) {
        int optimisticFilled;
        FluidStack aggressiveDrained = from.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        int maximumFilled = to.fill(aggressiveDrained, IFluidHandler.FluidAction.SIMULATE);
        if (maximumFilled <= 0) {
            return false;
        }
        FluidStack optimisticDrained = from.drain(maximumFilled, IFluidHandler.FluidAction.SIMULATE);
        if (optimisticDrained.getAmount() > 0 && (optimisticFilled = to.fill(optimisticDrained, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            to.fill(from.drain(optimisticDrained, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            FluidHelpers.updateContainerItem(originalStack, itemHandler, after);
            sound.accept(optimisticDrained);
            return true;
        }
        to.fill(from.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        FluidHelpers.updateContainerItem(originalStack, itemHandler, after);
        sound.accept(aggressiveDrained);
        return true;
    }

    public static void updateContainerItem(ItemStack originalStack, IFluidHandlerItem itemHandler, AfterTransfer after) {
        if (originalStack.m_41619_()) {
            after.updateContainerItem(ItemStack.f_41583_);
        } else if (originalStack.m_41613_() == 1) {
            after.updateContainerItem(itemHandler.getContainer());
        } else {
            originalStack.m_41774_(1);
            after.updateContainerItem(originalStack, itemHandler.getContainer());
        }
    }

    public static boolean transferExact(IFluidHandler from, IFluidHandler to, int amount) {
        if (FluidHelpers.couldTransferExact(from, to, amount)) {
            to.fill(from.drain(amount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean couldTransferExact(IFluidHandler from, IFluidHandler to, int amount) {
        FluidStack drained = from.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        if (drained.getAmount() == amount) {
            return to.fill(drained, IFluidHandler.FluidAction.SIMULATE) == amount;
        }
        return false;
    }

    public static boolean pickupFluidInto(Level level, BlockPos pos, BlockState state, IFluidHandler to, boolean allowInfiniteSourceFilling) {
        FluidStack fluid = FluidHelpers.pickupFluid(level, pos, state, IFluidHandler.FluidAction.SIMULATE);
        if (fluid != null && !fluid.isEmpty()) {
            int filled;
            Fluid fluid2;
            if (allowInfiniteSourceFilling && (fluid2 = fluid.getFluid()) instanceof FlowingFluid) {
                FlowingFluid flowing = (FlowingFluid)fluid2;
                BlockState queryState = state;
                if (state.m_60734_() instanceof AqueductBlock) {
                    queryState = state.m_60819_().m_76188_();
                }
                if (ForgeEventFactory.canCreateFluidSource((Level)level, (BlockPos)pos, (BlockState)queryState, (boolean)flowing.canConvertToSource(queryState.m_60819_(), level, pos))) {
                    fluid.setAmount(Integer.MAX_VALUE);
                }
            }
            if ((filled = to.fill(fluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                FluidHelpers.pickupFluid(level, pos, state, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static FluidStack pickupFluid(Level level, BlockPos pos, BlockState state, IFluidHandler.FluidAction action) {
        return FluidHelpers.pickupFluid(level, pos, state, action, fluid -> FluidHelpers.playTransferSound(level, pos, fluid, Transfer.FILL));
    }

    @Nullable
    public static FluidStack pickupFluid(Level level, BlockPos pos, BlockState state, IFluidHandler.FluidAction action, Consumer<FluidStack> sound) {
        Block block = state.m_60734_();
        if (block instanceof BucketPickupExtension) {
            BucketPickupExtension pickup = (BucketPickupExtension)block;
            FluidStack fluid = pickup.pickupBlock((LevelAccessor)level, pos, state, action);
            sound.accept(fluid);
            return fluid;
        }
        if (block instanceof BucketPickup) {
            BucketPickup pickup = (BucketPickup)block;
            if (action.execute()) {
                ItemStack stack = pickup.m_142598_((LevelAccessor)level, pos, state);
                FluidStack fluid = stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> cap.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY);
                sound.accept(fluid);
                return fluid;
            }
            return new FluidStack(state.m_60819_().m_76152_(), 1000);
        }
        return null;
    }

    public static boolean emptyFluidFrom(IFluidHandler handler, Level level, BlockPos pos, BlockState state, @Nullable BlockHitResult hit, boolean allowPlacingSourceBlocks) {
        BlockState toPlace;
        LiquidBlockContainer container;
        boolean willReplace;
        Block block = state.m_60734_();
        FluidStack simulatedDrained = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        Fluid fluid = simulatedDrained.getFluid();
        boolean bl = willReplace = state.m_60795_() || state.m_60722_(fluid) || block instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, fluid) && allowPlacingSourceBlocks;
        if (!willReplace) {
            if (hit == null) {
                return false;
            }
            BlockPos relativePos = hit.m_82425_().m_121945_(hit.m_82434_());
            return FluidHelpers.emptyFluidFrom(handler, level, relativePos, level.m_8055_(relativePos), null, allowPlacingSourceBlocks);
        }
        if (fluid.getFluidType().isVaporizedOnPlacement(level, pos, simulatedDrained)) {
            handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, fluid) && simulatedDrained.getAmount() >= 1000) {
            if (allowPlacingSourceBlocks) {
                container.m_7361_((LevelAccessor)level, pos, state, fluid.m_76145_());
                handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                FluidHelpers.playTransferSound(level, pos, simulatedDrained, Transfer.DRAIN);
                return true;
            }
            return false;
        }
        if (allowPlacingSourceBlocks && simulatedDrained.getAmount() >= 1000) {
            toPlace = fluid.m_76145_().m_76188_();
        } else if (state.m_60819_().m_76152_() == fluid) {
            toPlace = state;
        } else if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            toPlace = flowing.m_75953_(1, false).m_76188_();
        } else {
            return false;
        }
        if (state.m_60734_() != toPlace.m_60734_()) {
            if (!level.f_46443_ && state.m_60722_(fluid) && !state.m_278721_()) {
                level.m_46961_(pos, true);
            }
            level.m_7731_(pos, toPlace, 3);
        }
        handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        FluidHelpers.playTransferSound(level, pos, simulatedDrained, Transfer.DRAIN);
        return true;
    }

    public static void playTransferSound(Level level, BlockPos pos, FluidStack stack, Transfer type) {
        FluidType fluidType;
        SoundEvent sound;
        if (stack.getFluid() == ForgeMod.MILK.get()) {
            stack = new FluidStack((Fluid)Fluids.f_76193_, stack.getAmount());
        }
        if ((sound = (fluidType = stack.getFluid().getFluidType()).getSound(stack, type == Transfer.FILL ? SoundActions.BUCKET_FILL : SoundActions.BUCKET_EMPTY)) != null) {
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static boolean isAirOrEmptyFluid(BlockState state) {
        return state.m_60795_() || state.m_60734_() == state.m_60819_().m_76152_().m_76145_().m_76188_().m_60734_();
    }

    public static boolean isEmptyFluid(BlockState state) {
        return !state.m_60819_().m_76178_() && state.m_60734_() == state.m_60819_().m_76152_().m_76145_().m_76188_().m_60734_();
    }

    @Nullable
    public static BlockState fillWithFluid(BlockState state, Fluid fluid) {
        FlowingFluid flowing;
        if (state.m_60819_().m_76152_() == fluid) {
            return state;
        }
        if (state.m_60795_()) {
            return fluid.m_76145_().m_76188_();
        }
        if (fluid instanceof FlowingFluid && (flowing = (FlowingFluid)fluid).m_6212_(state.m_60819_().m_76152_())) {
            return fluid.m_76145_().m_76188_();
        }
        Block block = state.m_60734_();
        if (block instanceof IFluidLoggable) {
            IFluidLoggable fluidBlock = (IFluidLoggable)block;
            FluidProperty property = fluidBlock.getFluidProperty();
            if (property.canContain(fluid)) {
                return (BlockState)state.m_61124_((Property)property, (Comparable)property.keyFor(fluid));
            }
        } else if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            if (fluid == Fluids.f_76193_) {
                return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
            }
            if (fluid == Fluids.f_76191_) {
                return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
            }
        }
        return null;
    }

    public static BlockState emptyFluidFrom(BlockState state) {
        Block block;
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        if ((block = state.m_60734_()) instanceof IFluidLoggable) {
            IFluidLoggable fluidBlock = (IFluidLoggable)block;
            FluidProperty property = fluidBlock.getFluidProperty();
            state = (BlockState)state.m_61124_((Property)property, (Comparable)property.keyFor(Fluids.f_76191_));
        }
        if (FluidHelpers.isAirOrEmptyFluid(state)) {
            state = Blocks.f_50016_.m_49966_();
        }
        if (FluidHelpers.isMeltableIce(state)) {
            state = Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public static boolean isMeltableIce(BlockState state) {
        return state.m_60734_() == Blocks.f_50126_ || state.m_60734_() == TFCBlocks.SEA_ICE.get() || state.m_60734_() == TFCBlocks.ICE_PILE.get();
    }

    public static boolean isSame(FluidState state, Fluid expected) {
        return state.m_76152_().m_6212_(expected);
    }

    public static boolean canMixFluids(Fluid left, Fluid right) {
        return FluidHelpers.canMixFluids(left) && FluidHelpers.canMixFluids(right);
    }

    public static boolean canMixFluids(Fluid fluid) {
        return fluid instanceof FlowingFluid && Helpers.isFluid(fluid, TFCTags.Fluids.MIXABLE);
    }

    public static FluidState getNewFluidWithMixing(FlowingFluid self, Level level, BlockPos pos, BlockState blockStateIn, boolean canConvertToSource, int dropOff) {
        BlockPos abovePos;
        BlockState aboveState;
        FluidState aboveFluid;
        BlockState offsetState;
        int maxAdjacentFluidAmount = 0;
        FlowingFluid maxAdjacentFluid = self;
        int adjacentSourceBlocks = 0;
        Object2IntArrayMap adjacentSourceBlocksByFluid = new Object2IntArrayMap(2);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.m_121945_(direction);
            offsetState = level.m_8055_(offsetPos);
            FluidState offsetFluid = offsetState.m_60819_();
            if (!(offsetFluid.m_76152_() instanceof FlowingFluid) || !((FlowingFluidAccessor)self).invoke$canPassThroughWall(direction, (BlockGetter)level, pos, blockStateIn, offsetPos, offsetState)) continue;
            if (offsetFluid.m_76170_() && ForgeEventFactory.canCreateFluidSource((Level)level, (BlockPos)offsetPos, (BlockState)offsetState, (boolean)offsetFluid.canConvertToSource(level, offsetPos))) {
                ++adjacentSourceBlocks;
                adjacentSourceBlocksByFluid.mergeInt((Object)((FlowingFluid)offsetFluid.m_76152_()), 1, Integer::sum);
            }
            if (offsetFluid.m_76186_() <= maxAdjacentFluidAmount && (offsetFluid.m_76186_() != maxAdjacentFluidAmount || !self.m_6212_(offsetFluid.m_76152_()))) continue;
            maxAdjacentFluidAmount = offsetFluid.m_76186_();
            maxAdjacentFluid = (FlowingFluid)offsetFluid.m_76152_();
        }
        if (adjacentSourceBlocks >= 2) {
            BlockState belowState = level.m_8055_(pos.m_7495_());
            FluidState belowFluid = belowState.m_60819_();
            if (belowFluid.m_76170_() && (offsetState = belowFluid.m_76152_()) instanceof FlowingFluid) {
                FlowingFluid belowFlowingFluid = (FlowingFluid)offsetState;
                if (adjacentSourceBlocksByFluid.getInt((Object)belowFluid.m_76152_()) >= 2) {
                    return FlowingFluidExtension.getSourceOrDefault((LevelReader)level, pos, belowFlowingFluid, false);
                }
            }
            if (belowState.m_280296_()) {
                FlowingFluid maximumAdjacentSourceFluid = self;
                int maximumAdjacentSourceBlocks = 0;
                for (Object2IntMap.Entry entry : adjacentSourceBlocksByFluid.object2IntEntrySet()) {
                    if (entry.getIntValue() <= maximumAdjacentSourceBlocks && entry.getKey() != self) continue;
                    maximumAdjacentSourceBlocks = entry.getIntValue();
                    maximumAdjacentSourceFluid = (FlowingFluid)entry.getKey();
                }
                if (maximumAdjacentSourceBlocks >= 3 || maximumAdjacentSourceBlocks >= 2 && self.m_6212_((Fluid)maximumAdjacentSourceFluid)) {
                    return FlowingFluidExtension.getSourceOrDefault((LevelReader)level, pos, maximumAdjacentSourceFluid, false);
                }
            }
        }
        if (!(aboveFluid = (aboveState = level.m_8055_(abovePos = pos.m_7494_())).m_60819_()).m_76178_() && aboveFluid.m_76152_() instanceof FlowingFluid && ((FlowingFluidAccessor)self).invoke$canPassThroughWall(Direction.UP, (BlockGetter)level, pos, blockStateIn, abovePos, aboveState)) {
            return ((FlowingFluid)aboveFluid.m_76152_()).m_75953_(8, true);
        }
        int selfFluidAmount = maxAdjacentFluidAmount - dropOff;
        if (selfFluidAmount <= 0) {
            return Fluids.f_76191_.m_76145_();
        }
        return maxAdjacentFluid.m_75953_(selfFluidAmount, false);
    }

    public static void setSourceBlock(Level level, BlockPos pos, Fluid fluid) {
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flow = (FlowingFluid)fluid;
            level.m_7731_(pos, flow.m_5613_().m_76145_().m_76188_(), 3);
        } else {
            level.m_7731_(pos, fluid.m_76145_().m_76188_(), 3);
        }
    }

    public static void tickFluid(LevelAccessor level, BlockPos pos, BlockState state, boolean tickWhenEmpty) {
        if (!state.m_60819_().m_76178_()) {
            Fluid fluid = state.m_60819_().m_76152_();
            level.m_186469_(pos, fluid, fluid.m_6718_((LevelReader)level));
        } else if (tickWhenEmpty) {
            level.m_186460_(pos, state.m_60734_(), 1);
        }
    }

    public static void tickFluid(LevelAccessor level, BlockPos pos, BlockState state) {
        FluidHelpers.tickFluid(level, pos, state, false);
    }

    public record AfterTransferWithPlayer(Player player, InteractionHand hand) implements AfterTransfer
    {
        @Override
        public void updateContainerItem(ItemStack newOriginalStack, ItemStack newContainerStack) {
            if (!this.player.m_7500_()) {
                this.player.m_21008_(this.hand, newOriginalStack);
            }
            if (!newContainerStack.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)newContainerStack.m_255036_(1));
            }
        }
    }

    @FunctionalInterface
    public static interface AfterTransfer {
        default public void updateContainerItem(ItemStack newOriginalStack) {
            this.updateContainerItem(newOriginalStack, ItemStack.f_41583_);
        }

        public void updateContainerItem(ItemStack var1, ItemStack var2);
    }

    public static enum Transfer {
        FILL,
        DRAIN;

    }
}

