/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.prey.RammingPreyAi;
import net.dries007.tfc.common.entities.prey.WildAnimal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class RammingPrey
extends WildAnimal {
    protected static final ImmutableList<SensorType<? extends Sensor<? super RammingPrey>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26822_, (Object)SensorType.f_26814_);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26331_, (Object)MemoryModuleType.f_148202_, (Object)MemoryModuleType.f_148203_, (Object)MemoryModuleType.f_217768_, (Object)MemoryModuleType.f_26382_);
    private final Supplier<SoundEvent> attack;
    public final AnimationState telegraphAnimation = new AnimationState();
    public final AnimationState attackingAnimation = new AnimationState();
    private boolean isTelegraphingAttack;
    private int telegraphAttackTick;
    private float attackDamageMultiplier = 1.0f;
    private final double rammingReach;
    public final AnimationState walkingAnimation = new AnimationState();

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.16f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 0.8);
    }

    public static AttributeSupplier.Builder createMediumAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, (double)0.16f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 0.9);
    }

    public static AttributeSupplier.Builder createLargeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.12f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public RammingPrey(EntityType<? extends RammingPrey> type, Level level, TFCSounds.EntitySound sounds, double rammingReach) {
        super(type, level, sounds);
        this.attack = sounds.attack().orElseThrow();
        this.rammingReach = rammingReach;
    }

    protected Brain.Provider<? extends RammingPrey> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return RammingPreyAi.makeBrain((Brain<? extends RammingPrey>)this.m_5490_().m_22073_(dynamic));
    }

    protected void m_8024_() {
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        RammingPreyAi.updateActivity(this);
    }

    public Brain<RammingPrey> m_6274_() {
        return super.m_6274_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            this.f_20939_.m_21936_(MemoryModuleType.f_26326_);
        }
        return hurt;
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().f_46443_) {
            EntityHelpers.startOrStop(this.walkingAnimation, EntityHelpers.isMovingOnLand((Entity)this), this.f_19797_);
        }
        super.m_8119_();
    }

    public void m_7822_(byte id) {
        if (id == 58) {
            this.isTelegraphingAttack = true;
        } else if (id == 59) {
            this.isTelegraphingAttack = false;
        } else if (id == 4) {
            this.attackingAnimation.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8107_() {
        this.telegraphAttackTick = this.isTelegraphingAttack ? ++this.telegraphAttackTick : 0;
        this.telegraphAttackTick = Mth.m_14045_((int)this.telegraphAttackTick, (int)0, (int)20);
        super.m_8107_();
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        RammingPreyAi.initMemories(this, level.m_213780_());
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, tag);
    }

    public int getTelegraphAttackTick() {
        return this.telegraphAttackTick;
    }

    public boolean isTelegraphingAttack() {
        return this.isTelegraphingAttack;
    }

    public Supplier<SoundEvent> getAttackSound() {
        return this.attack;
    }

    public void setAttackDamageMultiplier(float multiplier) {
        this.attackDamageMultiplier = multiplier;
    }

    public float getAttackDamageMultiplier() {
        return this.attackDamageMultiplier;
    }

    public double getRammingReach() {
        return this.rammingReach;
    }
}

