/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.horse;

import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface HorseProperties
extends MammalProperties {
    public static final AttributeModifier OLD_AGE_MODIFIER = new AttributeModifier("old_age", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final float TAMED_FAMILIARITY = 0.15f;
    public static final float MIN_MOVEMENT_SPEED = (float)HorseProperties.generateSpeed(() -> 0.0);
    public static final float MAX_MOVEMENT_SPEED = (float)HorseProperties.generateSpeed(() -> 1.0);
    public static final float MIN_JUMP_STRENGTH = (float)HorseProperties.generateJumpStrength(() -> 0.0);
    public static final float MAX_JUMP_STRENGTH = (float)HorseProperties.generateJumpStrength(() -> 1.0);
    public static final float MIN_HEALTH = HorseProperties.generateMaxHealth(v -> 0);
    public static final float MAX_HEALTH = HorseProperties.generateMaxHealth(v -> 1);

    public static float generateMaxHealth(IntUnaryOperator supplier) {
        return 15.0f + (float)supplier.applyAsInt(8) + (float)supplier.applyAsInt(9);
    }

    public static double generateJumpStrength(DoubleSupplier supplier) {
        return 0.4 + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2;
    }

    public static double generateSpeed(DoubleSupplier supplier) {
        return (0.45 + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3) * 0.25;
    }

    default public AbstractHorse getEntity() {
        return (AbstractHorse)MammalProperties.super.getEntity();
    }

    @Override
    default public void createGenes(CompoundTag tag, TFCAnimalProperties maleProperties) {
        MammalProperties.super.createGenes(tag, maleProperties);
        AbstractHorse female = this.getEntity();
        AbstractHorse male = (AbstractHorse)maleProperties;
        tag.m_128347_("maxHealth1", male.m_21172_(Attributes.f_22276_));
        tag.m_128347_("maxHealth2", female.m_21172_(Attributes.f_22276_));
        tag.m_128347_("jumpStrength1", male.m_21172_(Attributes.f_22288_));
        tag.m_128347_("jumpStrength2", female.m_21172_(Attributes.f_22288_));
        tag.m_128347_("movementSpeed1", male.m_21172_(Attributes.f_22279_));
        tag.m_128347_("movementSpeed2", female.m_21172_(Attributes.f_22279_));
    }

    @Override
    default public void applyGenes(CompoundTag tag, MammalProperties babyProperties) {
        MammalProperties.super.applyGenes(tag, babyProperties);
        AbstractHorse baby = (AbstractHorse)babyProperties;
        double maxHealth = tag.m_128425_("maxHealth1", 6) ? EntityHelpers.createOffspringAttribute(tag.m_128459_("maxHealth1"), tag.m_128459_("maxHealth2"), MIN_HEALTH, MAX_HEALTH, this.getEntity().m_217043_()) : (double)HorseProperties.generateMaxHealth(i -> this.getEntity().m_217043_().m_188502_());
        double jumpStrength = tag.m_128425_("jumpStrength1", 6) ? EntityHelpers.createOffspringAttribute(tag.m_128459_("jumpStrength1"), tag.m_128459_("jumpStrength2"), MIN_JUMP_STRENGTH, MAX_JUMP_STRENGTH, this.getEntity().m_217043_()) : HorseProperties.generateJumpStrength(() -> this.getEntity().m_217043_().m_188500_());
        double speed = tag.m_128425_("movementSpeed1", 6) ? EntityHelpers.createOffspringAttribute(tag.m_128459_("movementSpeed1"), tag.m_128459_("movementSpeed2"), MIN_MOVEMENT_SPEED, MAX_MOVEMENT_SPEED, this.getEntity().m_217043_()) : HorseProperties.generateSpeed(() -> this.getEntity().m_217043_().m_188500_());
        EntityHelpers.setNullableAttribute((LivingEntity)baby, Attributes.f_22288_, jumpStrength);
        EntityHelpers.setNullableAttribute((LivingEntity)baby, Attributes.f_22279_, speed);
        EntityHelpers.setNullableAttribute((LivingEntity)baby, Attributes.f_22276_, maxHealth);
    }

    @Override
    default public SoundEvent eatingSound(ItemStack stack) {
        return this.getEntity().m_7866_(stack);
    }

    @Override
    default public void tickAnimalData() {
        AttributeInstance speed;
        MammalProperties.super.tickAnimalData();
        if (!this.getEntity().m_9236_().m_5776_() && this.getGender() == TFCAnimalProperties.Gender.MALE && this.isReadyToMate()) {
            EntityHelpers.findFemaleMate((Animal)this);
        }
        if (this.getAgeType() == TFCAnimalProperties.Age.OLD && (speed = this.getEntity().m_21051_(Attributes.f_22279_)) != null && !speed.m_22109_(OLD_AGE_MODIFIER)) {
            speed.m_22118_(OLD_AGE_MODIFIER);
        }
        for (Entity entity : this.getEntity().m_20197_()) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_21023_((MobEffect)TFCEffects.OVERBURDENED.get())) continue;
            this.rejectPassengers();
            if (!(livingEntity instanceof Player)) break;
            Player player = (Player)livingEntity;
            player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.animal.horse_angry_overburdened"), true);
            break;
        }
    }

    default public void rejectPassengers() {
        AbstractHorse horse = this.getEntity();
        horse.m_20153_();
        horse.m_7564_();
        horse.m_9236_().m_7605_((Entity)horse, (byte)6);
    }
}

