/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.livestock.Mammal;
import net.dries007.tfc.config.animals.ProducingMammalConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class ProducingMammal
extends Mammal {
    public static final EntityDataAccessor<Long> DATA_PRODUCED = SynchedEntityData.m_135353_(ProducingMammal.class, EntityHelpers.LONG_SERIALIZER);
    protected final ForgeConfigSpec.IntValue produceTicks;
    protected final ForgeConfigSpec.DoubleValue produceFamiliarity;

    public ProducingMammal(EntityType<? extends ProducingMammal> animal, Level level, TFCSounds.EntitySound sounds, ProducingMammalConfig config) {
        super(animal, level, sounds, config.inner());
        this.produceTicks = config.produceTicks();
        this.produceFamiliarity = config.produceFamiliarity();
    }

    @Override
    public boolean isReadyForAnimalProduct() {
        return (double)this.getFamiliarity() > (Double)this.produceFamiliarity.get() && this.hasProduct();
    }

    @Override
    public void setProductsCooldown() {
        this.setProducedTick(Calendars.get((LevelReader)this.m_9236_()).getTicks());
    }

    @Override
    public long getProductsCooldown() {
        return Math.max(0L, (long)((Integer)this.produceTicks.get()).intValue() + this.getProducedTick() - Calendars.get((LevelReader)this.m_9236_()).getTicks());
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128356_("produced", this.getProducedTick());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setProducedTick(nbt.m_128454_("produced"));
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PRODUCED, (Object)0L);
    }

    public long getProducedTick() {
        return (Long)this.f_19804_.m_135370_(DATA_PRODUCED);
    }

    public void setProducedTick(long producedTick) {
        this.f_19804_.m_135381_(DATA_PRODUCED, (Object)producedTick);
    }
}

