/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.pet.MoveToTargetSinkIfNotSleeping;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.ai.predator.PredatorBehaviors;
import net.dries007.tfc.common.entities.predator.Predator;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.TryFindWater;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.level.Level;

public class AmphibiousPredatorAi {
    public static final ImmutableList<? extends SensorType<? extends Sensor<? super Predator>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_);
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = (ImmutableList)Util.m_137537_(() -> {
        ArrayList list = Lists.newArrayList(PredatorAi.MEMORY_TYPES);
        return ImmutableList.copyOf((Collection)list);
    });
    public static final int MAX_WANDER_DISTANCE = 10000;
    public static final int MAX_ATTACK_DISTANCE = 6400;

    public static Brain<?> makeBrain(Brain<? extends Predator> brain, Predator predator) {
        AmphibiousPredatorAi.initCoreActivity(brain);
        AmphibiousPredatorAi.initHuntActivity(brain);
        AmphibiousPredatorAi.initRetreatActivity(brain);
        PredatorAi.initRestActivity(brain);
        AmphibiousPredatorAi.initFightActivity(brain);
        brain.m_21912_(predator.diurnal ? (Schedule)TFCBrain.DIURNAL.get() : (Schedule)TFCBrain.NOCTURNAL.get());
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_((Activity)TFCBrain.HUNT.get());
        brain.m_21889_((Activity)TFCBrain.HUNT.get());
        brain.m_21862_(predator.m_9236_().m_46468_(), predator.m_9236_().m_46467_());
        return brain;
    }

    public static void updateActivity(Predator predator) {
        Brain<Predator> brain = predator.m_6274_();
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37988_));
        if (brain.m_21968_().isPresent()) {
            Activity current = (Activity)brain.m_21968_().get();
            if (current == Activity.f_37988_ && !brain.m_21874_(MemoryModuleType.f_26372_)) {
                brain.m_21862_(predator.m_9236_().m_46468_(), predator.m_9236_().m_46467_());
            } else if (current == Activity.f_37991_ && !brain.m_21874_(MemoryModuleType.f_26357_)) {
                brain.m_21862_(predator.m_9236_().m_46468_(), predator.m_9236_().m_46467_());
            }
        }
        predator.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
    }

    public static void initCoreActivity(Brain<? extends Predator> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)((Object)new MoveToTargetSinkIfNotSleeping()), (Object)new CountDownCooldownTicks((MemoryModuleType)TFCBrain.WAKEUP_TICKS.get())));
    }

    public static void initHuntActivity(Brain<? extends Predator> brain) {
        brain.m_21900_((Activity)TFCBrain.HUNT.get(), ImmutableList.of((Object)Pair.of((Object)0, PredatorBehaviors.becomePassiveIf(p -> p.m_21223_() < 5.0f, 200)), (Object)Pair.of((Object)1, (Object)StartAttacking.m_257710_(PredatorAi::getAttackTarget)), (Object)Pair.of((Object)2, SetLookTarget.create(8.0f, UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)3, (Object)TryFindWater.m_257908_((int)6, (float)1.0f)), (Object)Pair.of((Object)5, (Object)RandomStroll.m_257751_((float)1.0f)), (Object)Pair.of((Object)6, (Object)RandomStroll.m_257798_((float)1.0f, (boolean)false)), (Object)Pair.of((Object)7, (Object)SetWalkTargetFromLookTarget.m_258011_(AmphibiousPredatorAi::canSetWalkTargetFromLookTarget, AmphibiousPredatorAi::getSpeedModifier, (int)3)), (Object)Pair.of((Object)10, (Object)BabyFollowAdult.m_257685_((UniformInt)UniformInt.m_146622_((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)11, PredatorAi.createIdleMovementBehaviors()), (Object)Pair.of((Object)12, PredatorBehaviors.tickScheduleAndWake())));
    }

    public static void initRetreatActivity(Brain<? extends Predator> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)BehaviorBuilder.m_257845_(PredatorAi::hasNearbyAttacker, (OneShot)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26382_, (float)1.2f, (int)16, (boolean)true)), (Object)StrollToPoi.m_258086_((MemoryModuleType)MemoryModuleType.f_26359_, (float)0.7f, (int)5, (int)10000), PredatorAi.createIdleMovementBehaviors()), MemoryModuleType.f_26357_);
    }

    public static void initFightActivity(Brain<? extends Predator> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of(PredatorBehaviors.becomePassiveIf(p -> p.m_21223_() < 5.0f, 200), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257648_(AmphibiousPredatorAi::getSpeedModifier), (Object)MeleeAttack.m_257733_((int)40), PredatorBehaviors.stopAttackingIfTooFarFromHome()), MemoryModuleType.f_26372_);
    }

    private static float getSpeedModifier(LivingEntity entity) {
        return entity.m_20072_() ? 1.6f : 1.0f;
    }

    private static boolean canSetWalkTargetFromLookTarget(LivingEntity entity) {
        Level level = entity.m_9236_();
        Optional tracker = entity.m_6274_().m_21952_(MemoryModuleType.f_26371_);
        if (tracker.isPresent()) {
            BlockPos pos = ((PositionTracker)tracker.get()).m_6675_();
            return level.m_46801_(pos) == entity.m_20072_();
        }
        return false;
    }
}

