/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCLightBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;

public interface IGlow {
    default public Entity getEntity() {
        return (Entity)this;
    }

    public void setLightPos(BlockPos var1);

    public BlockPos getLightPos();

    default public int getLightLevel() {
        return 10;
    }

    default public int getLightUpdateDistanceSqr() {
        return 9;
    }

    default public int getLightUpdateInterval() {
        return 20;
    }

    default public void saveLight(CompoundTag tag) {
        BlockPos light = this.getLightPos();
        tag.m_128405_("lightX", light.m_123341_());
        tag.m_128405_("lightY", light.m_123342_());
        tag.m_128405_("lightZ", light.m_123343_());
    }

    default public void readLight(CompoundTag tag) {
        this.setLightPos(new BlockPos(tag.m_128451_("lightX"), tag.m_128451_("lightY"), tag.m_128451_("lightZ")));
    }

    default public void tickGlow() {
        Entity entity = this.getEntity();
        if (entity.f_19797_ % this.getLightUpdateInterval() == 0) {
            boolean initialized;
            BlockPos oldPos = this.getLightPos();
            BlockPos currentPos = entity.m_20183_();
            boolean bl = initialized = !oldPos.equals((Object)BlockPos.f_121853_);
            if (oldPos.m_123331_((Vec3i)currentPos) > (double)this.getLightUpdateDistanceSqr() || !initialized) {
                BlockState newState;
                if (initialized && entity.m_9236_().m_46805_(oldPos) && Helpers.isBlock(entity.m_9236_().m_8055_(oldPos), (Block)TFCBlocks.LIGHT.get())) {
                    entity.m_9236_().m_46597_(oldPos, entity.m_9236_().m_6425_(oldPos).m_76188_());
                }
                BlockState currentState = entity.m_9236_().m_8055_(currentPos);
                Fluid fluid = currentState.m_60819_().m_76152_();
                if (FluidHelpers.isAirOrEmptyFluid(currentState) && !currentState.m_61138_((Property)FlowingFluid.f_75948_) && (newState = FluidHelpers.fillWithFluid((BlockState)((Block)TFCBlocks.LIGHT.get()).m_49966_().m_61124_((Property)TFCLightBlock.LEVEL, (Comparable)Integer.valueOf(this.getLightLevel())), fluid)) != null) {
                    entity.m_9236_().m_46597_(currentPos, newState);
                    this.setLightPos(currentPos);
                }
            }
        }
    }

    default public void tryRemoveLight() {
        Entity entity = this.getEntity();
        Level level = entity.m_9236_();
        if (!level.m_46749_(this.getLightPos())) {
            return;
        }
        BlockPos light = this.getLightPos();
        BlockState state = level.m_8055_(light);
        if (Helpers.isBlock(state, (Block)TFCBlocks.LIGHT.get())) {
            level.m_46597_(light, state.m_60819_().m_76188_());
        }
    }
}

