/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import java.util.List;
import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.wood.SewingTableBlock;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.CallbackSlot;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.util.ArrayContainerData;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SewingTableContainer
extends Container
implements ISlotCallback,
ButtonHandlerContainer {
    public static final int NUM_SLOTS = 5;
    public static final int SLOT_YARN = 0;
    public static final int SLOT_TOOL = 1;
    public static final int SLOT_INPUT_1 = 2;
    public static final int SLOT_INPUT_2 = 3;
    public static final int SLOT_RESULT = 4;
    public static final int BURLAP_ID = 0;
    public static final int WOOL_ID = 1;
    public static final int REMOVE_ID = 2;
    public static final int NEEDLE_ID = 3;
    public static final int PLACE_STITCH_ID = 4;
    public static final int RECIPE_ID = 5;
    public static final int SQUARES_PER_CLOTH = 8;
    public static final int STITCHES_PER_YARN = 16;
    public static final int MAX_SQUARES = 32;
    public static final int MAX_STITCHES = 45;
    public static final int PLACED_SLOTS_OFFSET = 100;
    private final ItemStackHandler inventory;
    private final Inventory playerInventory;
    private final ContainerLevelAccess access;
    private final DataSlot activeMaterialData = DataSlot.m_39401_();
    private final ArrayContainerData placedMaterialData = new ArrayContainerData(32);
    private final ArrayContainerData stitchData = new ArrayContainerData(45);
    private final DataSlot burlapCount = DataSlot.m_39401_();
    private final DataSlot woolCount = DataSlot.m_39401_();
    private final DataSlot stringCount = DataSlot.m_39401_();
    private final DataSlot usedBurlap = DataSlot.m_39401_();
    private final DataSlot usedWool = DataSlot.m_39401_();
    private final DataSlot usedString = DataSlot.m_39401_();
    private final RecipeWrapper recipeWrapper = new RecipeWrapper(this);

    public static SewingTableContainer create(Inventory playerInventory, int windowId, ContainerLevelAccess access) {
        return (SewingTableContainer)new SewingTableContainer(playerInventory, windowId, access).init(playerInventory, 30);
    }

    private static boolean isWool(ItemStack item) {
        return Helpers.isItem(item, TFCTags.Items.SEWING_LIGHT_CLOTH);
    }

    private static boolean isBurlap(ItemStack item) {
        return Helpers.isItem(item, TFCTags.Items.SEWING_DARK_CLOTH);
    }

    private static boolean isString(ItemStack item) {
        return Helpers.isItem(item, (TagKey<Item>)Tags.Items.STRING);
    }

    private static boolean isNeedle(ItemStack item) {
        return Helpers.isItem(item, TFCTags.Items.SEWING_NEEDLES);
    }

    public SewingTableContainer(Inventory playerInventory, int windowId) {
        this(playerInventory, windowId, ContainerLevelAccess.f_39287_);
    }

    public SewingTableContainer(Inventory playerInventory, int windowId, ContainerLevelAccess access) {
        super((MenuType)TFCContainerTypes.SEWING_TABLE.get(), windowId);
        int i;
        this.playerInventory = playerInventory;
        this.access = access;
        this.inventory = new InventoryItemHandler(this, 5);
        this.m_38895_(this.activeMaterialData).m_6422_(-1);
        for (i = 0; i < 32; ++i) {
            this.placedMaterialData.m_8050_(i, -1);
        }
        for (i = 0; i < 45; ++i) {
            this.stitchData.m_8050_(i, 0);
        }
        this.m_38884_(this.placedMaterialData);
        this.m_38884_(this.stitchData);
        this.m_38895_(this.woolCount).m_6422_(0);
        this.m_38895_(this.burlapCount).m_6422_(0);
        this.m_38895_(this.stringCount).m_6422_(0);
        this.m_38895_(this.usedWool).m_6422_(0);
        this.m_38895_(this.usedBurlap).m_6422_(0);
        this.m_38895_(this.usedString).m_6422_(0);
        this.m_38893_(new ContainerListener(){

            public void m_7934_(AbstractContainerMenu container, int slotIndex, ItemStack stack) {
                if (slotIndex == 0 || slotIndex == 2 || slotIndex == 3) {
                    SewingTableContainer.this.woolCount.m_6422_(SewingTableContainer.this.countItem(SewingTableContainer::isWool));
                    SewingTableContainer.this.burlapCount.m_6422_(SewingTableContainer.this.countItem(SewingTableContainer::isBurlap));
                    SewingTableContainer.this.stringCount.m_6422_(SewingTableContainer.this.inventory.getStackInSlot(0).m_41613_());
                }
            }

            public void m_142153_(AbstractContainerMenu container, int dataSlotIndex, int value) {
            }
        });
    }

    public void updateResultItem() {
        this.access.m_39292_((level, pos) -> level.m_7465_().m_44015_((RecipeType)TFCRecipeTypes.SEWING.get(), (net.minecraft.world.Container)this.recipeWrapper, level).ifPresentOrElse(recipe -> {
            ItemStack result = recipe.m_8043_(level.m_9598_());
            if (result.m_41720_() != this.inventory.getStackInSlot(4).m_41720_()) {
                this.inventory.setStackInSlot(4, result);
                this.activeMaterialData.m_6422_(-1);
            }
        }, () -> this.inventory.setStackInSlot(4, ItemStack.f_41583_)));
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return SewingTableContainer.isString(stack);
        }
        if (slot == 1) {
            return SewingTableContainer.isNeedle(stack);
        }
        if (slot == 2 || slot == 3) {
            return !SewingTableContainer.isString(stack) && !SewingTableContainer.isNeedle(stack);
        }
        return slot != 4;
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return switch (slot) {
            case 1 -> 1;
            case 0, 2, 3 -> 8;
            default -> 64;
        };
    }

    public int countItem(Predicate<ItemStack> input) {
        ItemStack secondItem;
        int count = 0;
        ItemStack firstItem = this.inventory.getStackInSlot(2);
        if (input.test(firstItem)) {
            count += firstItem.m_41613_();
        }
        if (input.test(secondItem = this.inventory.getStackInSlot(3))) {
            count += secondItem.m_41613_();
        }
        return count;
    }

    public void m_6877_(Player player) {
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            if (slot == 4) continue;
            ItemStack stack = this.inventory.getStackInSlot(slot);
            this.giveItemStackToPlayerOrDrop(player, stack);
        }
        super.m_6877_(player);
    }

    @Override
    public boolean m_6875_(Player player) {
        return (Boolean)this.access.m_39299_((level, pos) -> level.m_8055_(pos).m_60734_() instanceof SewingTableBlock && player.m_20182_().m_82557_(pos.m_252807_()) < 64.0, (Object)true);
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        int activeMaterial = this.getActiveMaterial();
        if (buttonID == 0 || buttonID == 3 || buttonID == 1 || buttonID == 2) {
            activeMaterial = buttonID;
        } else if (buttonID - 100 >= 0 && buttonID - 100 < 32 && (activeMaterial == 0 || activeMaterial == 1 || activeMaterial == 2) && activeMaterial != this.getPlacedMaterial(buttonID - 100)) {
            if (activeMaterial == 0) {
                if (this.getBurlapCount() <= 0) {
                    return;
                }
                this.usedBurlap.m_6422_(this.usedBurlap.m_6501_() + 1);
                this.access.m_39292_((level, pos) -> Helpers.playSound(level, pos, SoundEvents.f_12642_));
            } else if (activeMaterial == 1) {
                if (this.getWoolCount() <= 0) {
                    return;
                }
                this.usedWool.m_6422_(this.usedWool.m_6501_() + 1);
                this.access.m_39292_((level, pos) -> Helpers.playSound(level, pos, SoundEvents.f_12642_));
            } else {
                this.access.m_39292_((level, pos) -> Helpers.playSound(level, pos, SoundEvents.f_12639_));
            }
            this.placedMaterialData.m_8050_(buttonID - 100, activeMaterial == 2 ? -1 : activeMaterial);
        } else if (buttonID == 4 && extraNBT != null && !this.inventory.getStackInSlot(1).m_41619_()) {
            if (this.getYarnCount() <= 0) {
                return;
            }
            this.usedString.m_6422_(this.usedString.m_6501_() + 1);
            this.stitchData.m_8050_(extraNBT.m_128451_("id"), extraNBT.m_128451_("stitchType"));
            this.access.m_39292_((level, pos) -> Helpers.playSound(level, pos, SoundEvents.f_12641_));
        }
        this.activeMaterialData.m_6422_(activeMaterial);
        this.updateResultItem();
        this.m_38946_();
    }

    @Override
    public void onSlotTake(Player player, int slot, ItemStack stack) {
        if (slot == 4) {
            int i;
            int toShrink;
            int woolCount = Mth.m_14167_((float)((float)this.usedWool.m_6501_() / 8.0f));
            int burlapCount = Mth.m_14167_((float)((float)this.usedBurlap.m_6501_() / 8.0f));
            ItemStack stack1 = this.inventory.getStackInSlot(2);
            ItemStack stack2 = this.inventory.getStackInSlot(3);
            if (SewingTableContainer.isWool(stack1)) {
                toShrink = Math.min(woolCount, stack1.m_41613_());
                stack1.m_41774_(toShrink);
                woolCount -= toShrink;
            }
            if (woolCount > 0 && SewingTableContainer.isWool(stack2)) {
                stack2.m_41774_(woolCount);
            }
            if (SewingTableContainer.isBurlap(stack1)) {
                toShrink = Math.min(burlapCount, stack1.m_41613_());
                stack1.m_41774_(toShrink);
                burlapCount -= toShrink;
            }
            if (burlapCount > 0 && SewingTableContainer.isBurlap(stack2)) {
                stack2.m_41774_(burlapCount);
            }
            this.inventory.getStackInSlot(0).m_41774_(Mth.m_14167_((float)((float)this.usedString.m_6501_() / 16.0f)));
            this.usedWool.m_6422_(0);
            this.usedBurlap.m_6422_(0);
            this.usedString.m_6422_(0);
            this.activeMaterialData.m_6422_(-1);
            for (i = 0; i < 32; ++i) {
                this.placedMaterialData.m_8050_(i, -1);
            }
            for (i = 0; i < 45; ++i) {
                this.stitchData.m_8050_(i, 0);
            }
            Helpers.damageItem(this.inventory.getStackInSlot(1), 1);
            this.access.m_39292_((level, pos) -> Helpers.playSound(level, pos, SoundEvents.f_12492_));
        }
    }

    public int getBurlapCount() {
        return this.burlapCount.m_6501_() * 8 - this.usedBurlap.m_6501_();
    }

    public int getWoolCount() {
        return this.woolCount.m_6501_() * 8 - this.usedWool.m_6501_();
    }

    public int getYarnCount() {
        return this.stringCount.m_6501_() * 16 - this.usedString.m_6501_();
    }

    public int getActiveMaterial() {
        return this.activeMaterialData.m_6501_();
    }

    public int getPlacedMaterial(int slot) {
        return this.placedMaterialData.m_6413_(slot);
    }

    public int getStitchAt(int slot) {
        return this.stitchData.m_6413_(slot);
    }

    public boolean canPickup(int slot) {
        return this.canPickup(this.inventory.getStackInSlot(slot));
    }

    public boolean canPickup(ItemStack item) {
        if (SewingTableContainer.isWool(item) && this.usedWool.m_6501_() > 0) {
            return false;
        }
        if (SewingTableContainer.isBurlap(item) && this.usedBurlap.m_6501_() > 0) {
            return false;
        }
        if (SewingTableContainer.isString(item) && this.usedString.m_6501_() > 0) {
            return false;
        }
        return !SewingTableContainer.isNeedle(item) || this.usedString.m_6501_() <= 0;
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new IncompatibleClassChangeError();
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.m_38903_(stack, 0, 5, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.m_38903_(stack, this.containerSlots, this.f_38839_.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        super.addContainerSlots();
        this.m_38897_((Slot)new SewingInputSlot(this, (IItemHandler)this.inventory, 0, 8, 83));
        this.m_38897_((Slot)new SewingInputSlot(this, (IItemHandler)this.inventory, 1, 26, 83));
        this.m_38897_((Slot)new SewingInputSlot(this, (IItemHandler)this.inventory, 2, 62, 83));
        this.m_38897_((Slot)new SewingInputSlot(this, (IItemHandler)this.inventory, 3, 80, 83));
        this.m_38897_((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, 4, 152, 83));
    }

    public static class RecipeWrapper
    implements EmptyInventory {
        private final SewingTableContainer container;

        public RecipeWrapper(SewingTableContainer container) {
            this.container = container;
        }

        public boolean stitchesMatch(List<Integer> inputs) {
            int[] array = this.container.stitchData.getArray();
            if (inputs.size() != array.length) {
                return false;
            }
            for (int i = 0; i < 45; ++i) {
                if (inputs.get(i) == array[i]) continue;
                return false;
            }
            return true;
        }

        public boolean squaresMatch(List<Integer> inputs) {
            int[] array = this.container.placedMaterialData.getArray();
            if (inputs.size() != array.length) {
                return false;
            }
            for (int i = 0; i < 32; ++i) {
                if (inputs.get(i) == array[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class SewingInputSlot
    extends CallbackSlot {
        private final SewingTableContainer callback;

        public SewingInputSlot(SewingTableContainer callback, IItemHandler inventory, int index, int x, int y) {
            super(callback, inventory, index, x, y);
            this.callback = callback;
        }

        public boolean m_8010_(Player player) {
            return this.callback.canPickup(this.m_7993_()) && super.m_8010_(player);
        }
    }
}

