/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.util.Helpers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;

public final class PlayerCommand {
    private static final String QUERY_HUNGER = "tfc.commands.player.query_hunger";
    private static final String QUERY_SATURATION = "tfc.commands.player.query_saturation";
    private static final String QUERY_WATER = "tfc.commands.player.query_water";
    private static final String QUERY_NUTRITION = "tfc.commands.player.query_nutrition";
    private static final String FAIL_INVALID_FOOD_STATS = "tfc.commands.player.fail_invalid_food_stats";

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"query").then(Commands.m_82127_((String)"hunger").executes(context -> PlayerCommand.queryHunger((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"saturation").executes(context -> PlayerCommand.querySaturation((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"water").executes(context -> PlayerCommand.queryWater((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"nutrition").executes(context -> PlayerCommand.queryNutrition((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.m_91474_((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"hunger").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(context -> PlayerCommand.setHunger((Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), false))))).then(Commands.m_82127_((String)"saturation").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(context -> PlayerCommand.setSaturation((Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), false))))).then(Commands.m_82127_((String)"water").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> PlayerCommand.setWater((Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").then(Commands.m_82127_((String)"hunger").executes(context -> PlayerCommand.setHunger((Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"), 20, false)))).then(Commands.m_82127_((String)"saturation").executes(context -> PlayerCommand.setSaturation((Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"), 5, false)))).then(Commands.m_82127_((String)"water").executes(context -> PlayerCommand.setWater((Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"), 100, false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"hunger").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)-20, (int)20)).executes(context -> PlayerCommand.setHunger((Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), true))))).then(Commands.m_82127_((String)"saturation").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)-20, (int)20)).executes(context -> PlayerCommand.setSaturation((Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), true))))).then(Commands.m_82127_((String)"water").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> PlayerCommand.setWater((Player)EntityArgument.m_91474_((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), true))))));
    }

    private static int queryHunger(CommandContext<CommandSourceStack> context, Player player) {
        int hunger = player.m_36324_().m_38702_();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)QUERY_HUNGER, (Object[])new Object[]{hunger}), true);
        return 1;
    }

    private static int querySaturation(CommandContext<CommandSourceStack> context, Player player) {
        float saturation = player.m_36324_().m_38722_();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)QUERY_SATURATION, (Object[])new Object[]{Float.valueOf(saturation)}), true);
        return 1;
    }

    private static int queryWater(CommandContext<CommandSourceStack> context, Player player) {
        if (player.m_36324_() instanceof TFCFoodData) {
            float water = ((TFCFoodData)player.m_36324_()).getThirst();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)QUERY_WATER, (Object[])new Object[]{Float.valueOf(water)}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)FAIL_INVALID_FOOD_STATS));
        return 0;
    }

    private static int queryNutrition(CommandContext<CommandSourceStack> context, Player player) {
        if (player.m_36324_() instanceof TFCFoodData) {
            float[] nutrition = ((TFCFoodData)player.m_36324_()).getNutrition().getNutrients();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)QUERY_NUTRITION), true);
            for (Nutrient nutrient : Nutrient.VALUES) {
                int percent = (int)(100.0f * nutrition[nutrient.ordinal()]);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)" - ").m_7220_((Component)Helpers.translateEnum(nutrient).m_130940_(nutrient.getColor())).m_130946_(": " + percent + "%"), true);
            }
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)FAIL_INVALID_FOOD_STATS));
        return 0;
    }

    private static int setHunger(Player player, int hunger, boolean add) {
        if (add) {
            hunger += player.m_36324_().m_38702_();
        }
        player.m_36324_().m_38705_(hunger);
        return 1;
    }

    private static int setSaturation(Player player, int saturation, boolean add) {
        if (add) {
            saturation = (int)((float)saturation + player.m_36324_().m_38722_());
        }
        player.m_36324_().m_38717_((float)saturation);
        return 1;
    }

    private static int setWater(Player player, int water, boolean add) {
        FoodData foodData = player.m_36324_();
        if (foodData instanceof TFCFoodData) {
            TFCFoodData stats = (TFCFoodData)foodData;
            if (add) {
                water = (int)((float)water + stats.getThirst());
            }
            stats.setThirst(water);
        }
        return 1;
    }
}

