/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Metal;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.command.EnumArgument;

public class AddTrimCommand {
    private static final String FAIL_NOT_APPLIED = "tfc.commands.trim.not_applied";
    private static final String FAIL_NOT_ARMOR = "tfc.commands.trim.not_armor";
    private static final String FAIL_BAD_MATERIAL = "tfc.commands.trim.bad_material";
    private static final String FAIL_BAD_TEMPLATE = "tfc.commands.trim.bad_template";

    public static LiteralArgumentBuilder<CommandSourceStack> create(CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trim").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"material", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pattern", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(context -> AddTrimCommand.addTrim((CommandSourceStack)context.getSource(), ((ItemInput)context.getArgument("material", ItemInput.class)).m_120979_(), ((ItemInput)context.getArgument("pattern", ItemInput.class)).m_120979_(), ((CommandSourceStack)context.getSource()).m_81375_().m_21205_()))).then(Commands.m_82129_((String)"metal", (ArgumentType)EnumArgument.enumArgument(Metal.Default.class)).executes(context -> AddTrimCommand.spawnSet((CommandSourceStack)context.getSource(), ((ItemInput)context.getArgument("material", ItemInput.class)).m_120979_(), ((ItemInput)context.getArgument("pattern", ItemInput.class)).m_120979_(), (Metal.Default)context.getArgument("metal", Metal.Default.class))))));
    }

    public static int spawnSet(CommandSourceStack source, Item materialItem, Item patternItem, Metal.Default metal) throws CommandSyntaxException {
        if (!metal.hasArmor()) {
            source.m_81352_((Component)Component.m_237115_((String)FAIL_NOT_ARMOR));
            return 0;
        }
        Map<Metal.ItemType, RegistryObject<Item>> map = TFCItems.METAL_ITEMS.get(metal);
        ServerPlayer player = source.m_81375_();
        for (Metal.ItemType type : new Metal.ItemType[]{Metal.ItemType.HELMET, Metal.ItemType.CHESTPLATE, Metal.ItemType.GREAVES, Metal.ItemType.BOOTS}) {
            ItemStack stack = ((Item)map.get((Object)type).get()).m_7968_();
            AddTrimCommand.addTrim(source, materialItem, patternItem, stack);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
        return 1;
    }

    public static int addTrim(CommandSourceStack source, Item materialItem, Item patternItem, ItemStack item) {
        Optional material = TrimMaterials.m_266539_((RegistryAccess)source.m_5894_(), (ItemStack)materialItem.m_7968_());
        Optional pattern = TrimPatterns.m_266468_((RegistryAccess)source.m_5894_(), (ItemStack)patternItem.m_7968_());
        if (material.isEmpty()) {
            source.m_81352_((Component)Component.m_237115_((String)FAIL_BAD_MATERIAL));
            return 0;
        }
        if (pattern.isEmpty()) {
            source.m_81352_((Component)Component.m_237115_((String)FAIL_BAD_TEMPLATE));
            return 0;
        }
        if (ArmorTrim.m_266570_((RegistryAccess)source.m_5894_(), (ItemStack)item, (ArmorTrim)new ArmorTrim((Holder)material.get(), (Holder)pattern.get()))) {
            return 1;
        }
        source.m_81352_((Component)Component.m_237115_((String)FAIL_NOT_APPLIED));
        return 0;
    }
}

