/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.glass;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blocks.Gem;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.capabilities.glass.IGlassworkingTool;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum GlassOperation {
    BLOW,
    ROLL,
    STRETCH,
    PINCH,
    FLATTEN,
    SAW,
    AMETHYST,
    SODA_ASH,
    SULFUR,
    IRON,
    RUBY,
    LAPIS_LAZULI,
    PYRITE,
    SAPPHIRE,
    GOLD,
    GRAPHITE,
    COPPER,
    NICKEL,
    TIN,
    SILVER,
    TABLE_POUR,
    BASIN_POUR;

    public static final GlassOperation[] VALUES;
    public static final Supplier<Map<Item, GlassOperation>> POWDERS;

    @Nullable
    public static GlassOperation byIndex(int id) {
        return id >= 0 && id < VALUES.length ? VALUES[id] : null;
    }

    @Nullable
    public static GlassOperation get(ItemStack stack, Player player) {
        if (stack.m_41619_()) {
            return player.m_20154_().f_82480_ < -0.95 ? STRETCH : BLOW;
        }
        Item item = stack.m_41720_();
        if (item instanceof IGlassworkingTool) {
            IGlassworkingTool tool = (IGlassworkingTool)item;
            return tool.getOperation();
        }
        return null;
    }

    @Nullable
    public static GlassOperation getByPowder(ItemStack stack) {
        return POWDERS.get().get(stack.m_41720_());
    }

    public SoundEvent getSound() {
        return this == BLOW ? (SoundEvent)TFCSounds.BELLOWS_BLOW.get() : SoundEvents.f_11671_;
    }

    public boolean hasRequiredTemperature(ItemStack stack) {
        return this == SAW || HeatCapability.getTemperature(stack) > Heat.FAINT_RED.getMin();
    }

    static {
        VALUES = GlassOperation.values();
        POWDERS = Suppliers.memoize(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)((Item)TFCItems.POWDERS.get((Object)Powder.SODA_ASH).get()), (Object)SODA_ASH);
            builder.put((Object)((Item)TFCItems.POWDERS.get((Object)Powder.SULFUR).get()), (Object)SULFUR);
            builder.put((Object)((Item)TFCItems.POWDERS.get((Object)Powder.GRAPHITE).get()), (Object)GRAPHITE);
            builder.put((Object)((Item)TFCItems.ORE_POWDERS.get((Object)Ore.HEMATITE).get()), (Object)IRON);
            builder.put((Object)((Item)TFCItems.ORE_POWDERS.get((Object)Ore.LIMONITE).get()), (Object)IRON);
            builder.put((Object)((Item)TFCItems.ORE_POWDERS.get((Object)Ore.MAGNETITE).get()), (Object)IRON);
            builder.put((Object)((Item)TFCItems.ORE_POWDERS.get((Object)Ore.NATIVE_GOLD).get()), (Object)GOLD);
            builder.put((Object)((Item)TFCItems.ORE_POWDERS.get((Object)Ore.NATIVE_COPPER).get()), (Object)COPPER);
            builder.put((Object)((Item)TFCItems.ORE_POWDERS.get((Object)Ore.MALACHITE).get()), (Object)COPPER);
            builder.put((Object)((Item)TFCItems.ORE_POWDERS.get((Object)Ore.TETRAHEDRITE).get()), (Object)COPPER);
            builder.put((Object)((Item)TFCItems.ORE_POWDERS.get((Object)Ore.CASSITERITE).get()), (Object)TIN);
            builder.put((Object)((Item)TFCItems.ORE_POWDERS.get((Object)Ore.GARNIERITE).get()), (Object)NICKEL);
            builder.put((Object)((Item)TFCItems.ORE_POWDERS.get((Object)Ore.NATIVE_SILVER).get()), (Object)SILVER);
            builder.put((Object)((Item)TFCItems.GEM_DUST.get((Object)Gem.AMETHYST).get()), (Object)AMETHYST);
            builder.put((Object)((Item)TFCItems.GEM_DUST.get((Object)Gem.RUBY).get()), (Object)RUBY);
            builder.put((Object)((Item)TFCItems.GEM_DUST.get((Object)Gem.LAPIS_LAZULI).get()), (Object)LAPIS_LAZULI);
            builder.put((Object)((Item)TFCItems.GEM_DUST.get((Object)Gem.PYRITE).get()), (Object)PYRITE);
            builder.put((Object)((Item)TFCItems.GEM_DUST.get((Object)Gem.SAPPHIRE).get()), (Object)SAPPHIRE);
            return builder.build();
        });
    }
}

