/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.forge;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;

public enum ForgingBonus implements StringRepresentable
{
    NONE(() -> Double.POSITIVE_INFINITY),
    MODESTLY_FORGED(() -> ((ForgeConfigSpec.DoubleValue)TFCConfig.SERVER.anvilModestlyForgedThreshold).get()),
    WELL_FORGED(() -> ((ForgeConfigSpec.DoubleValue)TFCConfig.SERVER.anvilWellForgedThreshold).get()),
    EXPERTLY_FORGED(() -> ((ForgeConfigSpec.DoubleValue)TFCConfig.SERVER.anvilExpertForgedThreshold).get()),
    PERFECTLY_FORGED(() -> ((ForgeConfigSpec.DoubleValue)TFCConfig.SERVER.anvilPerfectlyForgedThreshold).get());

    private static final String KEY = "tfc:forging_bonus";
    private static final String KEY_AUTHOR = "tfc:forging_author";
    private static final ForgingBonus[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final DoubleSupplier minRatio;

    public static ForgingBonus valueOf(int i) {
        return i < 0 ? VALUES[0] : (i >= VALUES.length ? VALUES[VALUES.length - 1] : VALUES[i]);
    }

    public static ForgingBonus byRatio(float ratio) {
        for (int i = VALUES.length - 1; i > 0; --i) {
            if (!(ForgingBonus.VALUES[i].minRatio.getAsDouble() > (double)ratio)) continue;
            return VALUES[i];
        }
        return NONE;
    }

    public static void addTooltipInfo(ItemStack stack, List<Component> tooltips) {
        ForgingBonus bonus = ForgingBonus.get(stack);
        if (bonus != NONE) {
            MutableComponent name = bonus.getDisplayName();
            if (ForgingBonus.getAuthor(stack).isPresent()) {
                tooltips.add((Component)Tooltips.author(ForgingBonus.getAuthor(stack).get()));
            }
            tooltips.add((Component)Helpers.translateEnum(bonus).m_130940_(ChatFormatting.GREEN));
        }
    }

    public static boolean applyLikeUnbreaking(ItemStack stack, RandomSource random) {
        ForgingBonus bonus;
        if (stack.m_41763_() && (bonus = ForgingBonus.get(stack)) != NONE) {
            return random.m_188501_() < bonus.durability();
        }
        return false;
    }

    public static ForgingBonus get(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(KEY, 3)) {
            return ForgingBonus.valueOf(tag.m_128451_(KEY));
        }
        return NONE;
    }

    public static Optional<String> getAuthor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(KEY_AUTHOR, 8)) {
            return Optional.of(tag.m_128461_(KEY_AUTHOR));
        }
        return Optional.empty();
    }

    public static void set(ItemStack stack, ForgingBonus bonus) {
        ForgingBonus.set(stack, bonus, null);
    }

    public static void set(ItemStack stack, ForgingBonus bonus, Player player) {
        if (bonus != NONE) {
            stack.m_41784_().m_128405_(KEY, bonus.ordinal());
            if (player != null) {
                stack.m_41784_().m_128359_(KEY_AUTHOR, player.m_7755_().getString());
            }
        } else {
            stack.m_41749_(KEY);
        }
    }

    public static ItemStack copy(ItemStack from, ItemStack to) {
        ForgingBonus bonus = ForgingBonus.get(from);
        if (bonus != NONE) {
            ForgingBonus.set(to, bonus);
            Optional<String> author = ForgingBonus.getAuthor(from);
            if (author.isPresent()) {
                to.m_41784_().m_128359_(KEY_AUTHOR, author.get());
            }
        }
        return to;
    }

    private ForgingBonus(DoubleSupplier minRatio) {
        this.minRatio = minRatio;
    }

    public MutableComponent getDisplayName() {
        return Helpers.translateEnum(this);
    }

    public String m_7912_() {
        return this.serializedName;
    }

    public float efficiency() {
        return Helpers.lerp((float)this.ordinal() * 0.25f, 1.0f, ((Double)TFCConfig.SERVER.anvilMaxEfficiencyMultiplier.get()).floatValue());
    }

    public float durability() {
        return Helpers.lerp((float)this.ordinal() * 0.25f, 0.0f, ((Double)TFCConfig.SERVER.anvilMaxDurabilityMultiplier.get()).floatValue());
    }

    public float damage() {
        return Helpers.lerp((float)this.ordinal() * 0.25f, 1.0f, ((Double)TFCConfig.SERVER.anvilMaxDamageMultiplier.get()).floatValue());
    }

    static {
        VALUES = ForgingBonus.values();
    }
}

