/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.food;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoodHandler
implements ICapabilitySerializable<CompoundTag>,
IFood {
    public static final int DEFAULT_DECAY_TICKS = 528000;
    public static final long ROTTEN_DATE = Long.MIN_VALUE;
    public static final long NEVER_DECAY_DATE = Long.MAX_VALUE;
    public static final long ROTTEN_CREATION_DATE = Long.MIN_VALUE;
    public static final long NEVER_DECAY_CREATION_DATE = -2L;
    public static final long UNKNOWN_CREATION_DATE = -1L;
    private static final AtomicBoolean NON_DECAYING = new AtomicBoolean(true);
    protected final List<FoodTrait> foodTraits = new ArrayList<FoodTrait>(2);
    private final LazyOptional<IFood> capability;
    protected FoodData data;
    protected long creationDate;
    protected boolean isNonDecaying;

    public static void setNonDecaying(boolean value) {
        NON_DECAYING.set(value);
    }

    public FoodHandler(FoodData data) {
        this.data = data;
        this.isNonDecaying = NON_DECAYING.get();
        this.capability = LazyOptional.of(() -> this);
        this.creationDate = -1L;
    }

    @Override
    public long getCreationDate() {
        if (this.isNonDecaying) {
            return -1L;
        }
        if (this.creationDate == -1L) {
            this.creationDate = FoodCapability.getRoundedCreationDate();
        }
        if (this.creationDate == -2L) {
            return -2L;
        }
        long rottenDate = this.calculateRottenDate(this.creationDate);
        if (rottenDate == Long.MAX_VALUE) {
            this.creationDate = -2L;
        }
        if (rottenDate < Calendars.get().getTicks()) {
            this.creationDate = Long.MIN_VALUE;
        }
        return this.creationDate;
    }

    @Override
    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public long getRottenDate() {
        if (this.isNonDecaying) {
            return Long.MAX_VALUE;
        }
        long creationDate = this.getCreationDate();
        if (creationDate == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        if (creationDate == -2L) {
            return Long.MAX_VALUE;
        }
        long rottenDate = this.calculateRottenDate(creationDate);
        if (rottenDate < Calendars.get().getTicks()) {
            return Long.MIN_VALUE;
        }
        return rottenDate;
    }

    @Override
    public boolean isTransientNonDecaying() {
        return this.isNonDecaying;
    }

    @Override
    public FoodData getData() {
        return this.data;
    }

    @Override
    public float getDecayDateModifier() {
        float mod = this.data.decayModifier() * ((Double)Helpers.getValueOrDefault(TFCConfig.SERVER.foodDecayModifier)).floatValue();
        for (FoodTrait trait : this.foodTraits) {
            mod *= trait.getDecayModifier();
        }
        return mod == 0.0f ? Float.POSITIVE_INFINITY : 1.0f / mod;
    }

    @Override
    public void setNonDecaying() {
        this.isNonDecaying = true;
        this.creationDate = -1L;
    }

    @Override
    public List<FoodTrait> getTraits() {
        return this.foodTraits;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == FoodCapability.CAPABILITY || cap == FoodCapability.NETWORK_CAPABILITY) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_("creationDate", this.getCreationDate());
        if (this.isDynamic()) {
            nbt.m_128365_("foodData", (Tag)this.data.write());
        }
        ListTag traitList = new ListTag();
        for (FoodTrait trait : this.foodTraits) {
            traitList.add((Object)StringTag.m_129297_((String)FoodTrait.getId(trait).toString()));
        }
        nbt.m_128365_("traits", (Tag)traitList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.foodTraits.clear();
        if (this.isDynamic()) {
            this.data = FoodData.read(nbt.m_128469_("foodData"));
        }
        ListTag traitList = nbt.m_128437_("traits", 8);
        for (int i = 0; i < traitList.size(); ++i) {
            FoodTrait trait = FoodTrait.getTrait(Helpers.resourceLocation(traitList.m_128778_(i)));
            if (trait == null) continue;
            this.foodTraits.add(trait);
        }
        this.creationDate = nbt.m_128441_("creationDate") ? nbt.m_128454_("creationDate") : -1L;
    }

    protected boolean isDynamic() {
        return false;
    }

    private long calculateRottenDate(long creationDateIn) {
        float decayMod = this.getDecayDateModifier();
        if (decayMod == Float.POSITIVE_INFINITY) {
            return Long.MAX_VALUE;
        }
        return creationDateIn + (long)(decayMod * 528000.0f);
    }

    public static class Dynamic
    extends FoodHandler {
        protected List<ItemStack> ingredients = new ArrayList<ItemStack>();
        private boolean isReal = false;

        public Dynamic() {
            super(FoodData.EMPTY);
        }

        public void setFood(FoodData data) {
            this.data = data;
            this.isReal = true;
        }

        @Override
        public boolean isTransientNonDecaying() {
            return !this.isReal || this.isNonDecaying;
        }

        public void setIngredients(List<ItemStack> ingredients) {
            this.ingredients = ingredients;
        }

        public List<ItemStack> getIngredients() {
            return this.ingredients;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128365_("ingredients", (Tag)Helpers.writeItemStacksToNbt(this.ingredients));
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            Helpers.readItemStacksFromNbt(this.ingredients, nbt.m_128437_("ingredients", 10));
        }

        @Override
        public void addTooltipInfo(ItemStack stack, List<Component> text) {
            super.addTooltipInfo(stack, text);
            for (ItemStack ingredient : this.ingredients) {
                if (ingredient.m_41619_()) continue;
                text.add((Component)Tooltips.countOfItem(ingredient).m_130940_(ChatFormatting.GRAY));
            }
        }

        @Override
        public boolean isDynamic() {
            return true;
        }
    }
}

