/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import javax.annotation.Nonnull;
import net.dries007.tfc.common.container.ISlotCallback;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public record InventoryWrapper(Container container, ISlotCallback callback) implements IItemHandlerModifiable
{
    public void setStackInSlot(int slot, ItemStack stack) {
        this.container.m_6836_(slot, stack);
        this.callback.setAndUpdateSlots(slot);
    }

    public int getSlots() {
        return this.container.m_6643_();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.container.m_8020_(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                this.setStackInSlot(slot, reachedLimit ? stack.m_255036_(limit) : stack);
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
                this.callback.setAndUpdateSlots(slot);
            }
        }
        return reachedLimit ? stack.m_255036_(stack.m_41613_() - limit) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.f_41583_);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.setStackInSlot(slot, existing.m_255036_(existing.m_41613_() - toExtract));
        }
        return existing.m_255036_(toExtract);
    }

    public int getSlotLimit(int slot) {
        return this.callback.getSlotStackLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.callback.isItemValid(slot, stack);
    }

    private int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }
}

